/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.ae.monitor.datasource.common.list;

import com.google.common.collect.Interner;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executor;
import org.eclipse.scada.ae.event.EventProcessor;
import org.eclipse.scada.ae.monitor.common.MessageDecorator;
import org.eclipse.scada.ae.monitor.common.MonitorDecorator;
import org.eclipse.scada.ae.monitor.datasource.AbstractMasterItemMonitor;
import org.eclipse.scada.ae.monitor.datasource.AbstractVariantMonitor;
import org.eclipse.scada.ae.monitor.datasource.Helper;
import org.eclipse.scada.ae.monitor.datasource.common.ListSeverity;
import org.eclipse.scada.ae.monitor.datasource.common.list.Configuration;
import org.eclipse.scada.ca.ConfigurationDataHelper;
import org.eclipse.scada.core.Variant;
import org.eclipse.scada.core.VariantEditor;
import org.eclipse.scada.da.client.DataItemValue;
import org.eclipse.scada.da.master.MasterItem;
import org.eclipse.scada.sec.UserInformation;
import org.eclipse.scada.utils.osgi.pool.ObjectPoolTracker;
import org.osgi.framework.BundleContext;

public class ListMonitor
extends AbstractVariantMonitor {
    private Configuration configuration;

    public ListMonitor(BundleContext context, Executor executor, Interner<String> stringInterner, ObjectPoolTracker<MasterItem> poolTracker, EventProcessor eventProcessor, String id, String prefix, String defaultMonitorType) {
        super(context, executor, stringInterner, poolTracker, eventProcessor, id, "org.eclipse.scada.ae.monitor.list", prefix, defaultMonitorType);
    }

    protected int getDefaultHandlerPriority() {
        return 600;
    }

    public synchronized void update(UserInformation userInformation, Map<String, String> properties) throws Exception {
        super.update(userInformation, properties);
        ConfigurationDataHelper cfg = new ConfigurationDataHelper(properties);
        Configuration c = new Configuration(this.configuration, (AbstractMasterItemMonitor)this);
        c.setDefaultAck(cfg.getBoolean("defaultAck", false));
        c.setDefaultSeverity((ListSeverity)cfg.getEnum("defaultSeverity", ListSeverity.class, (Enum)ListSeverity.OK));
        c.setMessageAttribute(cfg.getString("messageAttribute"));
        HashMap<Variant, ListSeverity> severityMap = new HashMap<Variant, ListSeverity>();
        ListSeverity[] listSeverityArray = ListSeverity.values();
        int n = listSeverityArray.length;
        int n2 = 0;
        while (n2 < n) {
            ListSeverity severity = listSeverityArray[n2];
            for (String str : cfg.getPrefixed("values." + severity.name() + ".").values()) {
                severityMap.put(VariantEditor.toVariant((String)str), severity);
            }
            ++n2;
        }
        c.setSeverityMap(severityMap);
        HashMap<Variant, Boolean> ackMap = new HashMap<Variant, Boolean>();
        for (String str : cfg.getPrefixed("values.ack.").values()) {
            ackMap.put(VariantEditor.toVariant((String)str), true);
        }
        for (String str : cfg.getPrefixed("values.nak.").values()) {
            ackMap.put(VariantEditor.toVariant((String)str), false);
        }
        c.setAckMap(ackMap);
        c.sendEvents();
        this.configuration = c;
        this.reprocess();
    }

    protected void performValueUpdate(Map<String, Object> context, DataItemValue.Builder builder, Variant value) {
        if (this.configuration == null) {
            this.setOk(value, Helper.getTimestamp((DataItemValue.Builder)builder));
            return;
        }
        Boolean requireAck = this.configuration.ackMap.get(value);
        ListSeverity severity = this.configuration.severityMap.get(value);
        if (requireAck == null) {
            requireAck = this.configuration.defaultAck;
        }
        if (severity == null) {
            severity = this.configuration.defaultSeverity;
        }
        if (severity.getSeverity() == null) {
            this.setOk(value, Helper.getTimestamp((DataItemValue.Builder)builder));
        } else {
            this.setFailure(value, Helper.getTimestamp((DataItemValue.Builder)builder), severity.getSeverity(), requireAck, (MonitorDecorator)this.extractMessage(builder));
        }
    }

    private MessageDecorator extractMessage(DataItemValue.Builder builder) {
        if (this.configuration.messageAttribute == null) {
            return null;
        }
        return new MessageDecorator((Variant)builder.getAttributes().get(this.configuration.messageAttribute));
    }
}

