/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.ae.monitor.datasource.common.remote;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;
import org.eclipse.scada.ae.Event;
import org.eclipse.scada.ae.data.MonitorStatus;
import org.eclipse.scada.ae.data.MonitorStatusInformation;
import org.eclipse.scada.ae.event.EventProcessor;
import org.eclipse.scada.ae.monitor.MonitorListener;
import org.eclipse.scada.ae.monitor.MonitorService;
import org.eclipse.scada.ae.monitor.datasource.common.remote.PersistentState;
import org.eclipse.scada.core.Variant;
import org.eclipse.scada.da.client.DataItemValue;
import org.eclipse.scada.da.master.AbstractMasterHandlerImpl;
import org.eclipse.scada.da.master.MasterItem;
import org.eclipse.scada.ds.DataListener;
import org.eclipse.scada.ds.DataNode;
import org.eclipse.scada.ds.DataStore;
import org.eclipse.scada.sec.UserInformation;
import org.eclipse.scada.utils.osgi.SingleServiceListener;
import org.eclipse.scada.utils.osgi.SingleServiceTracker;
import org.eclipse.scada.utils.osgi.pool.ObjectPoolTracker;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class GenericRemoteMonitor
extends AbstractMasterHandlerImpl
implements MonitorService {
    private static final Logger logger = LoggerFactory.getLogger(GenericRemoteMonitor.class);
    protected final String id;
    protected MonitorStatus state;
    protected Date timestamp;
    private final Set<MonitorListener> listeners = new HashSet<MonitorListener>();
    protected final EventProcessor eventProcessor;
    protected final Executor executor;
    private String lastAckUser;
    private Date aknTimestamp;
    private final SingleServiceTracker<DataStore> tracker;
    private DataStore store;
    private final DataListener listener;
    private final BundleContext context;
    private PersistentState persistentState;

    public GenericRemoteMonitor(BundleContext context, Executor executor, ObjectPoolTracker<MasterItem> poolTracker, int priority, String id, EventProcessor eventProcessor) {
        super(poolTracker, priority);
        this.context = context;
        this.executor = executor;
        this.eventProcessor = eventProcessor;
        this.id = id;
        this.state = MonitorStatus.INIT;
        this.listener = new DataListener(){

            public void nodeChanged(DataNode node) {
                GenericRemoteMonitor.this.nodeChanged(node);
            }
        };
        this.tracker = new SingleServiceTracker(context, DataStore.class, (SingleServiceListener)new SingleServiceListener<DataStore>(){

            public void serviceChange(ServiceReference<DataStore> reference, DataStore service) {
                GenericRemoteMonitor.this.setStore(service);
            }
        });
        this.tracker.open();
    }

    protected synchronized void nodeChanged(DataNode node) {
        Object o = null;
        if (node != null) {
            o = node.getDataAsObject(this.context.getBundle(), null);
        }
        if (o == null) {
            o = new PersistentState();
        }
        logger.info("Loaded persistent state: {} current state {}", new Object[]{o, this.state});
        if (!(o instanceof PersistentState)) {
            return;
        }
        this.persistentState = (PersistentState)o;
        this.lastAckUser = this.persistentState.getLastAckUser();
        MonitorStatus currentState = this.state;
        this.state = this.persistentState.getState();
        Date currentTimestamp = this.timestamp;
        this.timestamp = this.persistentState.getTimestamp();
        Date currentAknTimestamp = this.aknTimestamp;
        this.aknTimestamp = this.persistentState.getAckTimestamp();
        MonitorStatusInformation info = this.createStatus();
        this.notifyListener(info);
        if (currentState != MonitorStatus.INIT) {
            this.setState(currentState, currentTimestamp, currentAknTimestamp);
        }
    }

    protected synchronized void setStore(DataStore store) {
        if (this.store != null) {
            this.store.detachListener(this.getNodeId(), this.listener);
        }
        this.store = store;
        if (this.store != null) {
            this.store.attachListener(this.getNodeId(), this.listener);
        }
    }

    private String getNodeId() {
        return String.valueOf(this.getId()) + "/remoteMonitor";
    }

    public synchronized void dispose() {
        this.tracker.close();
        super.dispose();
    }

    public String getId() {
        return this.id;
    }

    protected void setState(MonitorStatus state) {
        this.setState(state, new Date(), null);
    }

    protected synchronized void setState(MonitorStatus state, Date timestamp, Date aknTimestamp) {
        logger.debug("Update state - old: {}, new: {}", (Object)this.state, (Object)state);
        if (this.state != state) {
            this.state = state;
            this.timestamp = timestamp;
            if (aknTimestamp != null) {
                this.aknTimestamp = aknTimestamp;
            }
            logger.debug("State is: {}", (Object)state);
            this.doStore();
            this.doNotify();
        }
    }

    private void doStore() {
        DataStore store = this.store;
        if (store != null) {
            PersistentState state = new PersistentState();
            state.setAckTimestamp(this.aknTimestamp);
            state.setLastAckUser(this.lastAckUser);
            state.setState(this.state);
            state.setTimestamp(this.timestamp);
            store.writeNode(new DataNode(this.getNodeId(), (Serializable)state));
        }
    }

    private void doNotify() {
        MonitorStatusInformation info = this.createStatus();
        this.notifyListener(info);
        if (this.persistentState != null) {
            this.eventProcessor.publishEvent(this.createEvent(info, this.state.toString()));
        }
    }

    private synchronized void notifyListener(final MonitorStatusInformation info) {
        final ArrayList<MonitorListener> listnersClone = new ArrayList<MonitorListener>(this.listeners);
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                for (MonitorListener listener : listnersClone) {
                    listener.statusChanged(info);
                }
            }
        });
    }

    protected static Calendar getTimestamp(DataItemValue.Builder itemValue, String attributeName) {
        Calendar timestamp = null;
        if (attributeName != null) {
            Variant ts = (Variant)itemValue.getAttributes().get(attributeName);
            if (ts != null && ts.isNumber()) {
                timestamp = Calendar.getInstance();
                timestamp.setTimeInMillis(ts.asLong(Long.valueOf(0L)));
            }
        } else {
            timestamp = itemValue.getTimestamp();
        }
        if (timestamp == null) {
            timestamp = Calendar.getInstance();
        }
        return timestamp;
    }

    protected abstract void handleUpdate(DataItemValue.Builder var1);

    public synchronized void dataUpdate(Map<String, Object> context, DataItemValue.Builder value) {
        if (value == null) {
            this.setState(MonitorStatus.UNSAFE);
        } else {
            this.handleUpdate(value);
        }
    }

    private MonitorStatusInformation createStatus() {
        Date timestamp = this.timestamp;
        if (timestamp == null) {
            timestamp = new Date();
        }
        if (this.persistentState == null) {
            return new MonitorStatusInformation(this.id, MonitorStatus.INIT, this.makeTimestamp(timestamp).longValue(), null, null, this.makeTimestamp(this.aknTimestamp), this.lastAckUser, this.makeTimestamp(timestamp), null, this.getMonitorAttributes());
        }
        return new MonitorStatusInformation(this.id, this.state, this.makeTimestamp(timestamp).longValue(), null, null, this.makeTimestamp(this.aknTimestamp), this.lastAckUser, this.makeTimestamp(timestamp), null, this.getMonitorAttributes());
    }

    public Long makeTimestamp(Date date) {
        if (date == null) {
            return null;
        }
        return date.getTime();
    }

    protected Map<String, Variant> getMonitorAttributes() {
        return this.eventAttributes;
    }

    protected Event.EventBuilder createEventBuilder() {
        Event.EventBuilder builder = Event.create();
        builder.sourceTimestamp(new Date());
        builder.entryTimestamp(new Date());
        builder.attributes(this.eventAttributes);
        return builder;
    }

    private Event createEvent(MonitorStatusInformation info, String eventType) {
        Event.EventBuilder builder = this.createEventBuilder();
        builder.sourceTimestamp(new Date(info.getStatusTimestamp()));
        builder.entryTimestamp(new Date());
        builder.attribute(Event.Fields.SOURCE, (Object)this.id);
        builder.attribute(Event.Fields.EVENT_TYPE, (Object)eventType);
        return builder.build();
    }

    protected synchronized void publishAckRequestEvent(UserInformation user, Date aknTimestamp) {
        Event.EventBuilder builder = this.createEventBuilder();
        Date now = new Date();
        builder.sourceTimestamp(now);
        builder.entryTimestamp(now);
        builder.attribute(Event.Fields.SOURCE, (Object)this.id);
        builder.attribute(Event.Fields.EVENT_TYPE, (Object)"ACK-REQ");
        if (user != null && user.getName() != null) {
            builder.attribute(Event.Fields.ACTOR_NAME, (Object)user.getName());
            this.lastAckUser = user.getName();
        } else {
            this.lastAckUser = null;
        }
        this.doStore();
        this.notifyListener(this.createStatus());
        this.eventProcessor.publishEvent(builder.build());
    }

    protected DataItemValue.Builder injectState(DataItemValue.Builder builder) {
        builder.setAttribute(String.valueOf(this.id) + ".state", Variant.valueOf((Object)this.state.toString()));
        boolean alarm = false;
        switch (this.state) {
            case NOT_OK: 
            case NOT_OK_AKN: 
            case NOT_OK_NOT_AKN: {
                alarm = true;
                break;
            }
        }
        builder.setAttribute(String.valueOf(this.id) + ".alarm", Variant.valueOf((boolean)alarm));
        return builder;
    }

    public synchronized void addStatusListener(final MonitorListener listener) {
        if (this.listeners.add(listener)) {
            final MonitorStatusInformation state = this.createStatus();
            this.executor.execute(new Runnable(){

                @Override
                public void run() {
                    listener.statusChanged(state);
                }
            });
        }
    }

    public synchronized void removeStatusListener(MonitorListener listener) {
        this.listeners.remove(listener);
    }

    protected void reprocess() {
        if (!this.getMasterItems().isEmpty()) {
            this.executor.execute(new Runnable(){

                @Override
                public void run() {
                    logger.debug("Reprocessing {} master items", (Object)GenericRemoteMonitor.this.getMasterItems().size());
                    for (MasterItem item : GenericRemoteMonitor.this.getMasterItems()) {
                        item.reprocess();
                    }
                }
            });
        }
    }
}

