/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.ae.server.handler.storage;

import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Map;
import org.eclipse.scada.ae.Event;
import org.eclipse.scada.ae.event.EventService;
import org.eclipse.scada.ae.server.handler.AbstractEventHandler;
import org.eclipse.scada.ae.server.handler.EventHandler;
import org.eclipse.scada.ae.server.handler.EventHandlerFactory;
import org.eclipse.scada.ae.server.handler.InjectionContext;
import org.eclipse.scada.utils.osgi.SingleServiceListener;
import org.eclipse.scada.utils.osgi.SingleServiceTracker;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultStorageHandlerFactory
implements EventHandlerFactory {
    private static final Logger logger = LoggerFactory.getLogger(DefaultStorageHandlerFactory.class);
    private final SingleServiceTracker<EventService> tracker;
    private EventService service;
    private final BundleContext context;
    private final Dictionary<String, Object> serviceProperties = new Hashtable<String, Object>();
    private ServiceRegistration<EventHandlerFactory> handle;

    public DefaultStorageHandlerFactory() {
        this(FrameworkUtil.getBundle(DefaultStorageHandlerFactory.class).getBundleContext());
    }

    public DefaultStorageHandlerFactory(BundleContext context) {
        this.serviceProperties.put("service.description", "Default storage handler");
        this.serviceProperties.put("event.handler.factory.id", "defaultStorage");
        this.context = context;
        this.tracker = new SingleServiceTracker(context, EventService.class, (SingleServiceListener)new SingleServiceListener<EventService>(){

            public void serviceChange(ServiceReference<EventService> reference, EventService service) {
                DefaultStorageHandlerFactory.this.handleServiceChange(service);
            }
        });
        this.tracker.open();
    }

    protected synchronized void handleServiceChange(EventService service) {
        if (this.handle != null && service == null) {
            this.handle.unregister();
            this.handle = null;
        }
        this.service = service;
        if (this.handle == null && this.service != null) {
            this.handle = this.context.registerService(EventHandlerFactory.class, (Object)this, this.serviceProperties);
        }
    }

    public void dispose() {
        this.tracker.close();
    }

    public EventHandler createHandler(Map<String, String> properties) {
        return new AbstractEventHandler(){

            public Event handleEvent(Event event, InjectionContext context) {
                DefaultStorageHandlerFactory.this.processEvent(event);
                return event;
            }
        };
    }

    protected synchronized void processEvent(Event event) {
        if (this.service != null) {
            this.service.publishEvent(event);
        } else {
            logger.warn("Lost event - event: {}", (Object)event);
        }
    }
}

