/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.core.common.iec60870;

import org.eclipse.scada.ca.ConfigurationDataHelper;
import org.eclipse.scada.protocol.iec60870.ASDUAddressType;
import org.eclipse.scada.protocol.iec60870.CauseOfTransmissionType;
import org.eclipse.scada.protocol.iec60870.InformationObjectAddressType;
import org.eclipse.scada.protocol.iec60870.ProtocolOptions;

public final class Configurations {
    public static ProtocolOptions.Builder parseProtocolOptions(ConfigurationDataHelper cfg) {
        ProtocolOptions.Builder optionsBuilder = new ProtocolOptions.Builder();
        optionsBuilder.setTimeout1(cfg.getInteger("t1", optionsBuilder.getTimeout1()));
        optionsBuilder.setTimeout2(cfg.getInteger("t2", optionsBuilder.getTimeout2()));
        optionsBuilder.setTimeout3(cfg.getInteger("t3", optionsBuilder.getTimeout3()));
        optionsBuilder.setAdsuAddressType((ASDUAddressType)cfg.getEnum("asduAddressType", ASDUAddressType.class, (Enum)ASDUAddressType.SIZE_2));
        optionsBuilder.setCauseOfTransmissionType((CauseOfTransmissionType)cfg.getEnum("causeOfTransmissionType", CauseOfTransmissionType.class, (Enum)CauseOfTransmissionType.SIZE_2));
        optionsBuilder.setInformationObjectAddressType((InformationObjectAddressType)cfg.getEnum("informationObjectAddressType", InformationObjectAddressType.class, (Enum)InformationObjectAddressType.SIZE_3));
        optionsBuilder.setAcknowledgeWindow((short)cfg.getInteger("w", (int)optionsBuilder.getAcknowledgeWindow()));
        optionsBuilder.setMaxUnacknowledged((short)cfg.getInteger("k", (int)optionsBuilder.getMaxUnacknowledged()));
        optionsBuilder.setTimeZone(cfg.getTimeZone("timeZone", null));
        optionsBuilder.setIgnoreDaylightSavingTime(cfg.getBoolean("ignoreDaylightSavingTime", false));
        return optionsBuilder;
    }
}

