/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.da.core;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Stack;
import org.eclipse.scada.utils.lang.Immutable;
import org.eclipse.scada.utils.str.StringHelper;

@Immutable
public class Location {
    private final String[] location;
    public static final Location ROOT = new Location();

    public Location(String ... location) {
        this.location = (String[])location.clone();
    }

    public Location(Location location) {
        this.location = (String[])location.location.clone();
    }

    public Location(Location parent, String child) {
        ArrayList<String> result = new ArrayList<String>(parent.asList());
        if (child != null) {
            result.add(child);
        }
        this.location = result.toArray(new String[result.size()]);
    }

    @Deprecated
    public Location() {
        this.location = new String[0];
    }

    public Location(List<String> location) {
        this.location = location.toArray(new String[location.size()]);
    }

    public String[] asArray() {
        return (String[])this.location.clone();
    }

    public List<String> asList() {
        return Collections.unmodifiableList(Arrays.asList(this.location));
    }

    public String toString() {
        return this.toString("/");
    }

    public String toString(String separator) {
        return String.valueOf(separator) + StringHelper.join((Object[])this.location, (String)separator);
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.location);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Location other = (Location)obj;
        return Arrays.equals(this.location, other.location);
    }

    public Stack<String> getPathStack() {
        Stack<String> stack = new Stack<String>();
        int i = this.location.length;
        while (i > 0) {
            stack.push(this.location[i - 1]);
            --i;
        }
        return stack;
    }
}

