/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.ae.client.ngp;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;
import org.eclipse.scada.ae.BrowserListener;
import org.eclipse.scada.ae.client.ngp.ConnectionImpl;
import org.eclipse.scada.ae.data.BrowserEntry;

public class BrowserManager {
    private final Set<BrowserListener> browserListeners = new LinkedHashSet<BrowserListener>();
    private final ConnectionImpl connection;
    private final Executor executor;
    private final Map<String, BrowserEntry> currentEntries = new HashMap<String, BrowserEntry>();

    public BrowserManager(Executor executor, ConnectionImpl connection) {
        this.executor = executor;
        this.connection = connection;
    }

    public void addBrowserListener(final BrowserListener listener) {
        if (listener == null) {
            throw new NullPointerException();
        }
        boolean wasEmpty = this.browserListeners.isEmpty();
        if (this.browserListeners.add(listener)) {
            if (wasEmpty) {
                this.connection.sendStartBrowse();
            }
            final ArrayList<BrowserEntry> values = new ArrayList<BrowserEntry>(this.currentEntries.values());
            this.executor.execute(new Runnable(){

                @Override
                public void run() {
                    listener.dataChanged(values, Collections.emptySet(), true);
                }
            });
        }
    }

    public void removeBrowserListener(BrowserListener listener) {
        if (this.browserListeners.remove(listener) && this.browserListeners.isEmpty()) {
            this.connection.sendStopBrowse();
        }
    }

    public void dispose() {
    }

    public void onBound() {
        if (!this.browserListeners.isEmpty()) {
            this.connection.sendStartBrowse();
        }
    }

    public void onClosed() {
        this.setCurrentEntries(Collections.emptyList(), null, true);
    }

    private void setCurrentEntries(final List<BrowserEntry> addedOrUpdated, final Set<String> removed, final boolean full) {
        if (full) {
            this.currentEntries.clear();
        }
        if (addedOrUpdated != null) {
            for (BrowserEntry entry : addedOrUpdated) {
                this.currentEntries.put(entry.getId(), entry);
            }
        }
        if (removed != null) {
            for (String id : removed) {
                this.currentEntries.remove(id);
            }
        }
        for (final BrowserListener listener : this.browserListeners) {
            this.executor.execute(new Runnable(){

                @Override
                public void run() {
                    listener.dataChanged(addedOrUpdated, removed, full);
                }
            });
        }
    }

    public void updateData(List<BrowserEntry> addedOrUpdated, Set<String> removed) {
        this.setCurrentEntries(addedOrUpdated, removed, false);
    }
}

