/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.ae.server.handler.mail;

import java.util.LinkedList;
import java.util.Map;
import java.util.Properties;
import javax.mail.Address;
import javax.mail.Authenticator;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import javax.mail.internet.InternetAddress;
import org.eclipse.scada.ae.server.handler.EventHandler;
import org.eclipse.scada.ae.server.handler.EventHandlerFactory;
import org.eclipse.scada.ae.server.handler.mail.MailEventHandler;
import org.eclipse.scada.ae.server.handler.mail.MailSender;
import org.eclipse.scada.base.pipe.PipeService;
import org.eclipse.scada.ca.ConfigurationDataHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MailHandlerFactory
implements EventHandlerFactory {
    private static final Logger logger = LoggerFactory.getLogger(MailHandlerFactory.class);
    private PipeService pipeService;

    public void setPipeService(PipeService pipeService) {
        this.pipeService = pipeService;
    }

    public void unsetPipeService() {
        this.pipeService = null;
    }

    public EventHandler createHandler(Map<String, String> properties) throws Exception {
        ConfigurationDataHelper cfg = new ConfigurationDataHelper(properties);
        LinkedList<InternetAddress> to = new LinkedList<InternetAddress>();
        String id = cfg.getStringNonEmptyChecked("queue.id", null);
        String toStr = cfg.getString("to");
        if (toStr != null && !toStr.isEmpty()) {
            to.add(new InternetAddress(toStr));
        }
        for (String toStrEntry : cfg.getPrefixed("to.").values()) {
            to.add(new InternetAddress(toStrEntry));
        }
        if (to.isEmpty()) {
            throw new IllegalStateException("No recipients configured");
        }
        String fromString = cfg.getString("from");
        InternetAddress from = null;
        if (fromString != null && !fromString.isEmpty()) {
            from = new InternetAddress(fromString);
        }
        int retries = cfg.getInteger("retries", 60);
        Authenticator auth = null;
        final String username = cfg.getString("username");
        final String password = cfg.getString("password");
        if (username != null && password != null) {
            auth = new Authenticator(){

                protected PasswordAuthentication getPasswordAuthentication() {
                    return new PasswordAuthentication(username, password);
                }
            };
        }
        Properties props = cfg.getPrefixedProperties("session.");
        Session session = auth == null ? Session.getInstance((Properties)props) : Session.getInstance((Properties)props, (Authenticator)auth);
        if (logger.isInfoEnabled()) {
            logger.info("Mail session properties: ");
            for (Map.Entry<Object, Object> entry : props.entrySet()) {
                logger.info("\t{} -> '{}'", entry.getKey(), entry.getValue());
            }
        }
        MailSender sender = new MailSender(session, (Address)from, (Address[])to.toArray(new InternetAddress[0]), password);
        return new MailEventHandler(id, sender, this.pipeService, retries);
    }
}

