/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.ae.server.http;

import javax.servlet.Servlet;
import org.eclipse.scada.ae.server.http.internal.JsonServlet;
import org.eclipse.scada.ae.server.injector.EventInjectorQueue;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.http.HttpService;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Activator
implements BundleActivator {
    private static final Logger logger = LoggerFactory.getLogger(Activator.class);
    private static final String SERVLET_PATH = "/org.eclipse.scada.ae";
    private BundleContext context;
    private ServiceTracker<HttpService, HttpService> httpServiceTracker;
    private HttpService httpService;
    private EventInjectorQueue injector;

    public void start(BundleContext context) throws Exception {
        this.context = context;
        this.injector = new EventInjectorQueue(context);
        this.httpServiceTracker = new ServiceTracker(context, HttpService.class, this.createHttpServiceTrackerCustomizer());
        this.httpServiceTracker.open();
    }

    public void stop(BundleContext context) throws Exception {
        this.httpServiceTracker.close();
        this.injector.dispose();
        this.context = null;
    }

    private void bind() {
        if (this.httpService == null) {
            return;
        }
        try {
            this.httpService.registerServlet(SERVLET_PATH, (Servlet)new JsonServlet(this.injector), null, null);
            this.httpService.registerResources("/org.eclipse.scada.ae/ui", "/ui", null);
        }
        catch (Exception e) {
            logger.error("Failed to bind", (Throwable)e);
        }
    }

    private void unbind() {
        if (this.httpService != null) {
            this.httpService.unregister("/org.eclipse.scada.ae/ui");
            this.httpService.unregister(SERVLET_PATH);
        }
    }

    private ServiceTrackerCustomizer<HttpService, HttpService> createHttpServiceTrackerCustomizer() {
        return new ServiceTrackerCustomizer<HttpService, HttpService>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public HttpService addingService(ServiceReference<HttpService> reference) {
                HttpService service = (HttpService)Activator.this.context.getService(reference);
                Activator activator = Activator.this;
                synchronized (activator) {
                    if (Activator.this.httpService == null) {
                        Activator.this.httpService = service;
                        Activator.this.bind();
                    }
                }
                return service;
            }

            public void modifiedService(ServiceReference<HttpService> reference, HttpService service) {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void removedService(ServiceReference<HttpService> reference, HttpService service) {
                Activator activator = Activator.this;
                synchronized (activator) {
                    if (service != Activator.this.httpService) {
                        return;
                    }
                    Activator.this.unbind();
                    Activator.this.httpService = null;
                    Activator.this.context.ungetService(reference);
                }
            }
        };
    }
}

