/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.ae.server.syslog;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import org.eclipse.scada.ae.Event;
import org.eclipse.scada.ae.data.Severity;
import org.eclipse.scada.ae.server.handler.InjectionContext;
import org.eclipse.scada.ae.server.injector.EventInjectorQueue;
import org.eclipse.scada.ae.server.syslog.ReceiverConfiguration;
import org.eclipse.scada.core.Variant;
import org.eclipse.scada.protocol.relp.service.Receiver;
import org.eclipse.scada.protocol.relp.service.ReceiverHandler;
import org.eclipse.scada.protocol.relp.service.ReceiverHandlerFactory;
import org.eclipse.scada.protocol.relp.service.ReceiverSession;
import org.eclipse.scada.protocol.syslog.SyslogMessage;

public class ReceiverService {
    private final EventInjectorQueue injector;
    private final Receiver receiver;
    private final ReceiverHandlerFactory factory = new ReceiverHandlerFactory(){

        public ReceiverHandler createHandler() {
            return new ReceiverHandler(){

                public void opened(ReceiverSession session) {
                    ReceiverService.this.handleOpened(session);
                }

                public void closed(ReceiverSession session) {
                    ReceiverService.this.handleClosed(session);
                }

                public void message(ReceiverSession session, SyslogMessage message) {
                    ReceiverService.this.handleMessage(session, message);
                }
            };
        }
    };

    public ReceiverService(EventInjectorQueue injector, ReceiverConfiguration cfg) {
        this.injector = injector;
        this.receiver = ReceiverService.isLocal(cfg.getHost()) ? new Receiver(this.factory, (SocketAddress)new InetSocketAddress(InetAddress.getLoopbackAddress(), cfg.getPort())) : (ReceiverService.isWildcard(cfg.getHost()) ? new Receiver(this.factory, (SocketAddress)new InetSocketAddress(cfg.getPort())) : new Receiver(this.factory, (SocketAddress)new InetSocketAddress(cfg.getHost(), cfg.getPort())));
    }

    private static boolean isLocal(String host) {
        if (host == null) {
            return true;
        }
        if (host.isEmpty()) {
            return true;
        }
        return host.equals("*local*");
    }

    private static boolean isWildcard(String host) {
        return host.equals("*") || host.equals("*all*");
    }

    protected void fillCommon(Event.EventBuilder builder, ReceiverSession session) {
        builder.attribute(Event.Fields.ACTOR_TYPE, (Object)"SYSTEM");
        builder.attribute(Event.Fields.ACTOR_NAME, (Object)"SYSLOG");
        builder.attribute(Event.Fields.SYSTEM, (Object)ReceiverService.makeAddressString(session));
    }

    protected static String makeAddressString(ReceiverSession session) {
        InetSocketAddress ra = session.getRemoteAddress();
        return String.format("%s:%s", ra.getHostString(), ra.getPort());
    }

    protected void handleOpened(ReceiverSession session) {
        Event.EventBuilder builder = Event.create();
        this.fillCommon(builder, session);
        builder.attribute(Event.Fields.EVENT_TYPE, (Object)"CON");
        builder.attribute(Event.Fields.MESSAGE, (Object)"Syslog session opened");
        this.injector.injectEvent(builder.build(), this.makeContext());
    }

    protected void handleClosed(ReceiverSession session) {
        Event.EventBuilder builder = Event.create();
        this.fillCommon(builder, session);
        builder.attribute(Event.Fields.EVENT_TYPE, (Object)"DIS");
        builder.attribute(Event.Fields.MESSAGE, (Object)"Syslog session closed");
        this.injector.injectEvent(builder.build(), this.makeContext());
    }

    protected void handleMessage(ReceiverSession session, SyslogMessage message) {
        Severity sev = this.convert(message.getSeverity());
        if (sev == null) {
            return;
        }
        Event.EventBuilder builder = Event.create();
        this.fillCommon(builder, session);
        builder.attribute(Event.Fields.EVENT_TYPE, (Object)"LOG");
        builder.attribute(Event.Fields.MESSAGE, (Object)message.getMessage());
        builder.attribute(Event.Fields.SEVERITY, (Object)sev);
        builder.attribute(Event.Fields.SOURCE, this.makeSource(message));
        builder.attribute("level.0", (Object)message.getHostname());
        builder.attribute("level.1", (Object)message.getProcessName());
        if (message.getProcessName() != null) {
            builder.attribute("level.2", (Object)message.getProcessId());
        }
        builder.sourceTimestamp(message.getTimestamp().getTime());
        this.injector.injectEvent(builder.build(), this.makeContext());
    }

    private InjectionContext makeContext() {
        return new InjectionContext.Builder().sourceModule("org.eclipse.scada.ae.server.syslog").build();
    }

    private Variant makeSource(SyslogMessage message) {
        String name = message.getProcessName();
        Long id = message.getProcessId();
        if (name != null && id != null) {
            return Variant.valueOf((Object)String.format("%s:%s", name, id));
        }
        if (name != null) {
            return Variant.valueOf((Object)name);
        }
        return null;
    }

    private Severity convert(org.eclipse.scada.protocol.syslog.Severity severity) {
        switch (severity) {
            case EMERGENCY: 
            case ALERT: 
            case CRITICAL: 
            case ERROR: {
                return Severity.ERROR;
            }
            case WARNING: {
                return Severity.WARNING;
            }
            case NOTICE: 
            case INFORMATIONAL: 
            case DEBUG: {
                return Severity.INFORMATION;
            }
        }
        return Severity.ERROR;
    }

    public void dispose() {
        this.receiver.close();
    }
}

