/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.ae.slave.inject;

import java.sql.SQLException;
import java.util.Properties;
import org.eclipse.scada.ae.slave.inject.EventInjector;
import org.eclipse.scada.utils.osgi.SingleServiceListener;
import org.eclipse.scada.utils.osgi.jdbc.DataSourceFactoryTracker;
import org.eclipse.scada.utils.osgi.jdbc.DataSourceHelper;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.jdbc.DataSourceFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Activator
implements BundleActivator {
    public static final String SPECIFIC_PREFIX = "org.eclipse.scada.ae.slave.inject";
    private static final Logger logger = LoggerFactory.getLogger(Activator.class);
    private static BundleContext context;
    private DataSourceFactoryTracker tracker;
    private EventInjector injector;

    static BundleContext getContext() {
        return context;
    }

    public void start(BundleContext bundleContext) throws Exception {
        context = bundleContext;
        String driver = DataSourceHelper.getDriver((String)SPECIFIC_PREFIX, (String)"org.eclipse.scada.jdbc");
        if (driver == null) {
            logger.error("JDBC driver is not set");
            throw new IllegalStateException("JDBC driver name is not set");
        }
        this.tracker = new DataSourceFactoryTracker(bundleContext, driver, (SingleServiceListener)new SingleServiceListener<DataSourceFactory>(){

            public void serviceChange(ServiceReference<DataSourceFactory> reference, DataSourceFactory service) {
                Activator.this.setService(service);
            }
        });
        this.tracker.open();
    }

    protected void setService(DataSourceFactory service) {
        if (this.injector != null) {
            this.injector.dispose();
            this.injector = null;
        }
        if (service != null) {
            try {
                Long loginTimeout = DataSourceHelper.getLoginTimeout((Properties)System.getProperties(), (String)SPECIFIC_PREFIX, (String)"org.eclipse.scada.jdbc");
                this.injector = new EventInjector(service, DataSourceHelper.getDataSourceProperties((String)SPECIFIC_PREFIX, (String)"org.eclipse.scada.jdbc"), Integer.getInteger("org.eclipse.scada.ae.slave.inject.loopDelay", 10000), loginTimeout);
            }
            catch (SQLException e) {
                logger.warn("Failed to start event injector", (Throwable)e);
            }
        }
    }

    public void stop(BundleContext bundleContext) throws Exception {
        this.tracker.close();
        if (this.injector != null) {
            this.injector.dispose();
            this.injector = null;
        }
        context = null;
    }
}

