/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.da.server.common.osgi.factory;

import java.util.Dictionary;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.concurrent.Executor;
import org.eclipse.scada.core.Variant;
import org.eclipse.scada.da.server.common.DataItem;
import org.eclipse.scada.da.server.common.DataItemCommand;
import org.eclipse.scada.da.server.common.chain.AttributeWriteHandler;
import org.eclipse.scada.da.server.common.chain.AttributeWriteHandlerItem;
import org.eclipse.scada.da.server.common.chain.DataItemInputChained;
import org.eclipse.scada.da.server.common.chain.WriteHandler;
import org.eclipse.scada.da.server.common.chain.WriteHandlerItem;
import org.eclipse.scada.da.server.common.item.factory.ItemFactory;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;

public class DataItemFactory
implements ItemFactory {
    private final BundleContext context;
    private final String globalId;
    private final Executor executor;
    private final Map<String, DataItem> items = new HashMap<String, DataItem>();
    private final Map<String, ServiceRegistration<DataItem>> itemRegs = new HashMap<String, ServiceRegistration<DataItem>>();
    private final String delimiter = ".";

    public DataItemFactory(BundleContext context, Executor executor, String globalId) {
        this.executor = executor;
        this.context = context;
        this.globalId = globalId;
    }

    public synchronized DataItemInputChained createInput(String localId, Map<String, Variant> properties) {
        DataItem item = this.items.get(localId);
        if (item == null) {
            String id = this.getId(localId);
            DataItemInputChained newItem = new DataItemInputChained(id, this.executor);
            this.registerItem((DataItem)newItem, localId, this.fixProperties(properties));
            return newItem;
        }
        if (item instanceof DataItemInputChained) {
            return (DataItemInputChained)item;
        }
        return null;
    }

    public synchronized WriteHandlerItem createOutput(String localId, Map<String, Variant> properties, WriteHandler writeHandler) {
        DataItem item = this.items.get(localId);
        if (item == null) {
            String id = this.getId(localId);
            WriteHandlerItem newItem = new WriteHandlerItem(id, writeHandler, this.executor);
            this.registerItem((DataItem)newItem, localId, this.fixProperties(properties));
            return newItem;
        }
        if (item instanceof WriteHandlerItem) {
            return (WriteHandlerItem)item;
        }
        return null;
    }

    public synchronized AttributeWriteHandlerItem createOutput(String localId, Map<String, Variant> properties, AttributeWriteHandler writeHandler) {
        DataItem item = this.items.get(localId);
        if (item == null) {
            String id = this.getId(localId);
            AttributeWriteHandlerItem newItem = new AttributeWriteHandlerItem(id, writeHandler, this.executor);
            this.registerItem((DataItem)newItem, localId, this.fixProperties(properties));
            return newItem;
        }
        if (item instanceof AttributeWriteHandlerItem) {
            return (AttributeWriteHandlerItem)item;
        }
        return null;
    }

    public synchronized DataItemCommand createCommand(String localId, Map<String, Variant> properties) {
        DataItem item = this.items.get(localId);
        if (item == null) {
            DataItemCommand newItem = new DataItemCommand(this.getId(localId), this.executor);
            this.registerItem(item, localId, this.fixProperties(properties));
            return newItem;
        }
        if (item instanceof DataItemCommand) {
            return (DataItemCommand)item;
        }
        return null;
    }

    public WriteHandlerItem createInputOutput(String localId, Map<String, Variant> properties, WriteHandler writeHandler) {
        return this.createOutput(localId, properties, writeHandler);
    }

    private Map<String, Variant> fixProperties(Map<String, Variant> properties) {
        Map<String, Variant> localProperties = properties != null ? properties : new HashMap<String, Variant>(0);
        return localProperties;
    }

    protected void registerItem(DataItem newItem, String localId, Map<String, Variant> properties) {
        Hashtable<String, String> props = new Hashtable<String, String>();
        this.fillProperties(properties, props);
        ServiceRegistration handle = this.context.registerService(DataItem.class, (Object)newItem, props);
        this.items.put(localId, newItem);
        this.itemRegs.put(localId, (ServiceRegistration<DataItem>)handle);
    }

    protected void fillProperties(Map<String, Variant> properties, Dictionary<String, String> props) {
        String str;
        Variant description = properties.get("description");
        if (description != null && (str = description.asString(null)) != null) {
            props.put("service.description", str);
        }
    }

    protected String getId(String localId) {
        if (this.globalId == null) {
            return localId;
        }
        return String.valueOf(this.globalId) + "." + localId;
    }

    public synchronized void disposeAllItems() {
        for (ServiceRegistration<DataItem> reg : this.itemRegs.values()) {
            reg.unregister();
        }
        this.items.clear();
        this.itemRegs.clear();
    }

    public synchronized void disposeItem(DataItem dataItem) {
        for (Map.Entry<String, DataItem> entry : this.items.entrySet()) {
            if (entry.getValue() != dataItem) continue;
            this.items.remove(entry.getKey());
            ServiceRegistration<DataItem> reg = this.itemRegs.remove(entry.getKey());
            reg.unregister();
            return;
        }
    }

    public synchronized void dispose() {
        this.disposeAllItems();
    }
}

