/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.da.server.common;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.scada.core.AttributesHelper;
import org.eclipse.scada.core.Variant;
import org.eclipse.scada.da.server.common.AttributeMode;
import org.eclipse.scada.da.server.common.DataItemBase;

public class AttributeManager {
    private final DataItemBase item;
    private final Map<String, Variant> attributes = new HashMap<String, Variant>();

    public AttributeManager(DataItemBase item) {
        this.item = item;
    }

    public Map<String, Variant> getCopy() {
        return new HashMap<String, Variant>(this.attributes);
    }

    public Map<String, Variant> get() {
        return this.attributes;
    }

    public void update(Variant value, Map<String, Variant> updates, AttributeMode mode) {
        if (mode == null) {
            mode = AttributeMode.UPDATE;
        }
        switch (mode) {
            case SET: {
                this.set(value, updates);
                break;
            }
            case UPDATE: {
                this.update(value, updates);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(Variant value, Map<String, Variant> updates) {
        HashMap<String, Variant> diff = new HashMap<String, Variant>();
        Map<String, Variant> map = this.attributes;
        synchronized (map) {
            AttributesHelper.mergeAttributes(this.attributes, updates, diff);
            if (value != null || !diff.isEmpty()) {
                if (diff.isEmpty()) {
                    diff = null;
                }
                this.item.notifyData(value, diff);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void set(Variant value, Map<String, Variant> values) {
        HashMap<String, Variant> diff = new HashMap<String, Variant>();
        Map<String, Variant> map = this.attributes;
        synchronized (map) {
            AttributesHelper.set(this.attributes, values, diff);
            if (value != null || !diff.isEmpty()) {
                if (diff.isEmpty()) {
                    diff = null;
                }
                this.item.notifyData(value, diff);
            }
        }
    }

    public void update(String name, Variant value) {
        HashMap<String, Variant> updates = new HashMap<String, Variant>();
        updates.put(name, value);
        this.update(null, updates);
    }
}

