/**
 * Copyright (c) 2013 Jens Reimann and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Jens Reimann - initial API and implementation
 */
package org.eclipse.scada.da.server.jdbc.configuration.provider;

import java.util.ArrayList;
import java.util.Collection;

import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;

import org.eclipse.emf.edit.provider.ChangeNotifier;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.IChangeNotifier;
import org.eclipse.emf.edit.provider.IDisposable;
import org.eclipse.emf.edit.provider.IEditingDomainItemProvider;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.INotifyChangedListener;
import org.eclipse.emf.edit.provider.IStructuredItemContentProvider;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;

import org.eclipse.scada.da.server.jdbc.configuration.util.ConfigurationAdapterFactory;

/**
 * This is the factory that is used to provide the interfaces needed to support Viewers.
 * The adapters generated by this factory convert EMF adapter notifications into calls to {@link #fireNotifyChanged fireNotifyChanged}.
 * The adapters also support Eclipse property sheets.
 * Note that most of the adapters are shared among multiple instances.
 * <!-- begin-user-doc -->
 * <!-- end-user-doc -->
 * @generated
 */
public class ConfigurationItemProviderAdapterFactory extends ConfigurationAdapterFactory implements ComposeableAdapterFactory, IChangeNotifier, IDisposable
{
    /**
     * This keeps track of the root adapter factory that delegates to this adapter factory.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected ComposedAdapterFactory parentAdapterFactory;

    /**
     * This is used to implement {@link org.eclipse.emf.edit.provider.IChangeNotifier}.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected IChangeNotifier changeNotifier = new ChangeNotifier ();

    /**
     * This keeps track of all the supported types checked by {@link #isFactoryForType isFactoryForType}.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected Collection<Object> supportedTypes = new ArrayList<Object> ();

    /**
     * This constructs an instance.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public ConfigurationItemProviderAdapterFactory ()
    {
        supportedTypes.add ( IEditingDomainItemProvider.class );
        supportedTypes.add ( IStructuredItemContentProvider.class );
        supportedTypes.add ( ITreeItemContentProvider.class );
        supportedTypes.add ( IItemLabelProvider.class );
        supportedTypes.add ( IItemPropertySource.class );
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.scada.da.server.jdbc.configuration.ColumnMappingType} instances.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected ColumnMappingTypeItemProvider columnMappingTypeItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.scada.da.server.jdbc.configuration.ColumnMappingType}.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Adapter createColumnMappingTypeAdapter ()
    {
        if ( columnMappingTypeItemProvider == null )
        {
            columnMappingTypeItemProvider = new ColumnMappingTypeItemProvider ( this );
        }

        return columnMappingTypeItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.scada.da.server.jdbc.configuration.CommandsType} instances.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected CommandsTypeItemProvider commandsTypeItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.scada.da.server.jdbc.configuration.CommandsType}.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Adapter createCommandsTypeAdapter ()
    {
        if ( commandsTypeItemProvider == null )
        {
            commandsTypeItemProvider = new CommandsTypeItemProvider ( this );
        }

        return commandsTypeItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.scada.da.server.jdbc.configuration.ConnectionType} instances.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected ConnectionTypeItemProvider connectionTypeItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.scada.da.server.jdbc.configuration.ConnectionType}.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Adapter createConnectionTypeAdapter ()
    {
        if ( connectionTypeItemProvider == null )
        {
            connectionTypeItemProvider = new ConnectionTypeItemProvider ( this );
        }

        return connectionTypeItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.scada.da.server.jdbc.configuration.DocumentRoot} instances.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected DocumentRootItemProvider documentRootItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.scada.da.server.jdbc.configuration.DocumentRoot}.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Adapter createDocumentRootAdapter ()
    {
        if ( documentRootItemProvider == null )
        {
            documentRootItemProvider = new DocumentRootItemProvider ( this );
        }

        return documentRootItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.scada.da.server.jdbc.configuration.PropertyEntry} instances.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected PropertyEntryItemProvider propertyEntryItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.scada.da.server.jdbc.configuration.PropertyEntry}.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Adapter createPropertyEntryAdapter ()
    {
        if ( propertyEntryItemProvider == null )
        {
            propertyEntryItemProvider = new PropertyEntryItemProvider ( this );
        }

        return propertyEntryItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.scada.da.server.jdbc.configuration.QueryType} instances.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected QueryTypeItemProvider queryTypeItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.scada.da.server.jdbc.configuration.QueryType}.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Adapter createQueryTypeAdapter ()
    {
        if ( queryTypeItemProvider == null )
        {
            queryTypeItemProvider = new QueryTypeItemProvider ( this );
        }

        return queryTypeItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.scada.da.server.jdbc.configuration.RootType} instances.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected RootTypeItemProvider rootTypeItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.scada.da.server.jdbc.configuration.RootType}.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Adapter createRootTypeAdapter ()
    {
        if ( rootTypeItemProvider == null )
        {
            rootTypeItemProvider = new RootTypeItemProvider ( this );
        }

        return rootTypeItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.scada.da.server.jdbc.configuration.TabularQueryType} instances.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected TabularQueryTypeItemProvider tabularQueryTypeItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.scada.da.server.jdbc.configuration.TabularQueryType}.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Adapter createTabularQueryTypeAdapter ()
    {
        if ( tabularQueryTypeItemProvider == null )
        {
            tabularQueryTypeItemProvider = new TabularQueryTypeItemProvider ( this );
        }

        return tabularQueryTypeItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.scada.da.server.jdbc.configuration.UpdateColumnsType} instances.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected UpdateColumnsTypeItemProvider updateColumnsTypeItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.scada.da.server.jdbc.configuration.UpdateColumnsType}.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Adapter createUpdateColumnsTypeAdapter ()
    {
        if ( updateColumnsTypeItemProvider == null )
        {
            updateColumnsTypeItemProvider = new UpdateColumnsTypeItemProvider ( this );
        }

        return updateColumnsTypeItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.scada.da.server.jdbc.configuration.UpdateMappingType} instances.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected UpdateMappingTypeItemProvider updateMappingTypeItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.scada.da.server.jdbc.configuration.UpdateMappingType}.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Adapter createUpdateMappingTypeAdapter ()
    {
        if ( updateMappingTypeItemProvider == null )
        {
            updateMappingTypeItemProvider = new UpdateMappingTypeItemProvider ( this );
        }

        return updateMappingTypeItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.scada.da.server.jdbc.configuration.UpdateType} instances.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected UpdateTypeItemProvider updateTypeItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.scada.da.server.jdbc.configuration.UpdateType}.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Adapter createUpdateTypeAdapter ()
    {
        if ( updateTypeItemProvider == null )
        {
            updateTypeItemProvider = new UpdateTypeItemProvider ( this );
        }

        return updateTypeItemProvider;
    }

    /**
     * This returns the root adapter factory that contains this factory.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public ComposeableAdapterFactory getRootAdapterFactory ()
    {
        return parentAdapterFactory == null ? this : parentAdapterFactory.getRootAdapterFactory ();
    }

    /**
     * This sets the composed adapter factory that contains this factory.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public void setParentAdapterFactory ( ComposedAdapterFactory parentAdapterFactory )
    {
        this.parentAdapterFactory = parentAdapterFactory;
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public boolean isFactoryForType ( Object type )
    {
        return supportedTypes.contains ( type ) || super.isFactoryForType ( type );
    }

    /**
     * This implementation substitutes the factory itself as the key for the adapter.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Adapter adapt ( Notifier notifier, Object type )
    {
        return super.adapt ( notifier, this );
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Object adapt ( Object object, Object type )
    {
        if ( isFactoryForType ( type ) )
        {
            Object adapter = super.adapt ( object, type );
            if ( ! ( type instanceof Class<?> ) || ( ( (Class<?>)type ).isInstance ( adapter ) ) )
            {
                return adapter;
            }
        }

        return null;
    }

    /**
     * This adds a listener.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public void addListener ( INotifyChangedListener notifyChangedListener )
    {
        changeNotifier.addListener ( notifyChangedListener );
    }

    /**
     * This removes a listener.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public void removeListener ( INotifyChangedListener notifyChangedListener )
    {
        changeNotifier.removeListener ( notifyChangedListener );
    }

    /**
     * This delegates to {@link #changeNotifier} and to {@link #parentAdapterFactory}.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public void fireNotifyChanged ( Notification notification )
    {
        changeNotifier.fireNotifyChanged ( notification );

        if ( parentAdapterFactory != null )
        {
            parentAdapterFactory.fireNotifyChanged ( notification );
        }
    }

    /**
     * This disposes all of the item providers created by this factory. 
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public void dispose ()
    {
        if ( columnMappingTypeItemProvider != null )
            columnMappingTypeItemProvider.dispose ();
        if ( commandsTypeItemProvider != null )
            commandsTypeItemProvider.dispose ();
        if ( connectionTypeItemProvider != null )
            connectionTypeItemProvider.dispose ();
        if ( documentRootItemProvider != null )
            documentRootItemProvider.dispose ();
        if ( propertyEntryItemProvider != null )
            propertyEntryItemProvider.dispose ();
        if ( queryTypeItemProvider != null )
            queryTypeItemProvider.dispose ();
        if ( rootTypeItemProvider != null )
            rootTypeItemProvider.dispose ();
        if ( tabularQueryTypeItemProvider != null )
            tabularQueryTypeItemProvider.dispose ();
        if ( updateColumnsTypeItemProvider != null )
            updateColumnsTypeItemProvider.dispose ();
        if ( updateMappingTypeItemProvider != null )
            updateMappingTypeItemProvider.dispose ();
        if ( updateTypeItemProvider != null )
            updateTypeItemProvider.dispose ();
    }

}
