/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.da.server.simulation.component.modules;

import java.util.HashMap;
import java.util.Random;
import org.eclipse.scada.core.Variant;
import org.eclipse.scada.da.server.common.DataItemCommand;
import org.eclipse.scada.da.server.common.chain.DataItemInputChained;
import org.eclipse.scada.da.server.simulation.component.Hive;
import org.eclipse.scada.da.server.simulation.component.modules.BaseModule;
import org.eclipse.scada.utils.collection.MapBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleScale
extends BaseModule {
    private static final Logger logger = LoggerFactory.getLogger(SimpleScale.class);
    private Thread thread = null;
    private final int minDelay = 2000;
    private final int maxDelay = 10000;
    private final int minWeight = 10000;
    private final int maxWeight = 30000;
    private final double errorRatio = 0.1;
    private final DataItemInputChained valueInput;
    private final DataItemInputChained errorInput;
    private final DataItemInputChained activeInput;
    private static final Random random = new Random();

    public SimpleScale(Hive hive, String id) {
        super(hive, "scale." + id);
        HashMap<String, Variant> attributes = new HashMap<String, Variant>();
        attributes.put("tag", Variant.valueOf((Object)("scale." + id)));
        DataItemCommand startCommand = this.getOutput("start", attributes);
        startCommand.addListener(new DataItemCommand.Listener(){

            public void command(Variant value) {
                SimpleScale.this.startWeight();
            }
        });
        this.valueInput = this.getInput("value", attributes);
        this.errorInput = this.getInput("error", attributes);
        this.activeInput = this.getInput("active", new MapBuilder(attributes).put((Object)"description", (Object)Variant.valueOf((Object)"An indicator if a weight process is active. True means: active, false: not active")).getMap());
        this.activeInput.updateData(Variant.valueOf((boolean)false), null, null);
    }

    protected synchronized void startWeight() {
        if (this.thread != null) {
            return;
        }
        this.thread = new Thread(new Runnable(){

            @Override
            public void run() {
                SimpleScale.this.performWeight();
            }
        });
        this.thread.start();
    }

    protected void performWeight() {
        boolean error;
        int delay = 2000 + random.nextInt(10000 - 2000);
        logger.debug(String.format("Weight delay: %d", delay));
        this.activeInput.updateData(Variant.TRUE, new MapBuilder().put((Object)"sim.scale.last-delay", (Object)Variant.valueOf((int)delay)).getMap(), null);
        try {
            Thread.sleep(delay);
        }
        catch (InterruptedException interruptedException) {}
        boolean bl = error = random.nextDouble() < 0.1;
        if (error) {
            int errorCode = random.nextInt(255);
            this.finishWithError(errorCode);
        } else {
            int weight = 10000 + random.nextInt(30000 - 10000);
            this.finishWeight(weight);
        }
        this.activeInput.updateData(Variant.valueOf((boolean)false), null, null);
        this.thread = null;
    }

    protected void finishWeight(int value) {
        this.valueInput.updateData(Variant.valueOf((int)value), null, null);
        this.errorInput.updateData(Variant.NULL, null, null);
    }

    protected void finishWithError(int errorCode) {
        this.valueInput.updateData(Variant.NULL, null, null);
        this.errorInput.updateData(Variant.valueOf((int)errorCode), null, null);
    }
}

