/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.da.server.test.items;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.scada.core.InvalidOperationException;
import org.eclipse.scada.core.Variant;
import org.eclipse.scada.core.server.OperationParameters;
import org.eclipse.scada.da.core.WriteAttributeResult;
import org.eclipse.scada.da.core.WriteAttributeResults;
import org.eclipse.scada.da.core.WriteResult;
import org.eclipse.scada.da.server.common.DataItemOutput;
import org.eclipse.scada.utils.concurrent.InstantErrorFuture;
import org.eclipse.scada.utils.concurrent.InstantFuture;
import org.eclipse.scada.utils.concurrent.NotifyFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestItem1
extends DataItemOutput {
    private static final Logger logger = LoggerFactory.getLogger(TestItem1.class);

    public TestItem1(String name) {
        super(name);
    }

    public Map<String, Variant> getAttributes() {
        return new HashMap<String, Variant>();
    }

    public NotifyFuture<WriteAttributeResults> startSetAttributes(Map<String, Variant> attributes, OperationParameters operationParameters) {
        WriteAttributeResults results = new WriteAttributeResults();
        for (Map.Entry<String, Variant> entry : attributes.entrySet()) {
            logger.info("Attribute: '{}' => '{}'", (Object)entry.getKey(), (Object)entry.getValue());
            if (entry.getKey().startsWith("error")) {
                results.put((Object)entry.getKey(), (Object)new WriteAttributeResult((Throwable)new Exception("Testing error")));
                continue;
            }
            results.put((Object)entry.getKey(), (Object)WriteAttributeResult.OK);
        }
        return new InstantFuture((Object)results);
    }

    public NotifyFuture<WriteResult> startWriteValue(Variant value, OperationParameters operationParameters) {
        logger.debug("set value: {}", (Object)value.toString());
        try {
            String data = value.asString();
            if (data.startsWith("error")) {
                return new InstantErrorFuture((Throwable)new InvalidOperationException());
            }
            return new InstantFuture((Object)new WriteResult());
        }
        catch (Throwable e) {
            return new InstantErrorFuture(e);
        }
    }
}

