/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.sec.provider.script;

import java.util.Map;
import org.eclipse.scada.ca.ConfigurationDataHelper;
import org.eclipse.scada.sec.AuthenticationImplementation;
import org.eclipse.scada.sec.AuthorizationService;
import org.eclipse.scada.sec.authz.AuthorizationRule;
import org.eclipse.scada.sec.provider.script.AuthorizationEntry;
import org.eclipse.scada.utils.script.ScriptExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScriptAuthorizationProvider
implements AuthorizationService {
    private static final Logger logger = LoggerFactory.getLogger(ScriptAuthorizationProvider.class);
    private final ClassLoader classLoader = this.getClass().getClassLoader();
    private AuthenticationImplementation authenticationImplementation;

    public void setAuthenticationImplementation(AuthenticationImplementation authenticationImplementation) {
        this.authenticationImplementation = authenticationImplementation;
    }

    public AuthorizationRule createRule(Map<String, String> properties) throws Exception {
        logger.debug("Creating rule - {}", properties);
        return this.createEntry(new ConfigurationDataHelper(properties));
    }

    private ScriptExecutor makeScript(String engine, String script) throws Exception {
        if (script == null || script.isEmpty()) {
            return null;
        }
        return new ScriptExecutor(engine, script, this.classLoader);
    }

    private AuthorizationEntry createEntry(ConfigurationDataHelper cfg) throws Exception {
        ScriptExecutor script = this.makeScript(cfg.getString("script.engine", "JavaScript"), cfg.getString("script"));
        ScriptExecutor callbackScript = this.makeScript(cfg.getString("callbackScript.engine", "JavaScript"), cfg.getString("callbackScript"));
        return new AuthorizationEntry(script, callbackScript, this.authenticationImplementation);
    }
}

