/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.ae.server.storage.postgres.internal;

import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Properties;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import org.eclipse.scada.ae.server.storage.Storage;
import org.eclipse.scada.ae.server.storage.postgres.internal.JdbcStorage;
import org.eclipse.scada.utils.concurrent.NamedThreadFactory;
import org.eclipse.scada.utils.osgi.SingleServiceListener;
import org.eclipse.scada.utils.osgi.SingleServiceTracker;
import org.eclipse.scada.utils.osgi.jdbc.DataSourceHelper;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.jdbc.DataSourceFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Activator
implements BundleActivator {
    private static final String SPECIFIC_PREFIX = "org.eclipse.scada.ae.server.storage.jdbc";
    private static final Logger logger = LoggerFactory.getLogger(Activator.class);
    private static BundleContext context;
    private JdbcStorage jdbcStorage;
    private ServiceRegistration<?> jdbcStorageHandle;
    private SingleServiceTracker<DataSourceFactory> dataSouceFactoryTracker;
    private ScheduledExecutorService scheduler;

    static BundleContext getContext() {
        return context;
    }

    public void start(BundleContext bundleContext) throws Exception {
        context = bundleContext;
        String driver = DataSourceHelper.getDriver((String)SPECIFIC_PREFIX, (String)"org.eclipse.scada.jdbc");
        if (driver == null) {
            logger.error("JDBC driver is not set");
            throw new IllegalStateException("JDBC driver name is not set");
        }
        Filter filter = context.createFilter("(&(objectClass=" + DataSourceFactory.class.getName() + ")(" + "osgi.jdbc.driver.class" + "=" + driver + "))");
        this.dataSouceFactoryTracker = new SingleServiceTracker(bundleContext, filter, (SingleServiceListener)new SingleServiceListener<DataSourceFactory>(){

            public void serviceChange(ServiceReference<DataSourceFactory> reference, DataSourceFactory dsf) {
                try {
                    Activator.this.deactivate();
                }
                catch (Exception e) {
                    logger.error("an error occured on deactivating ae postgre storage", (Throwable)e);
                }
                if (dsf != null) {
                    try {
                        Activator.this.activate(dsf);
                    }
                    catch (Exception e) {
                        logger.error("an error occured on activating ae postgres storage", (Throwable)e);
                    }
                }
            }
        });
        this.dataSouceFactoryTracker.open();
    }

    private void activate(DataSourceFactory dataSourceFactory) throws Exception {
        this.scheduler = Executors.newSingleThreadScheduledExecutor((ThreadFactory)new NamedThreadFactory("org.eclipse.scada.ae.server.storage.postgresql/ScheduledExecutor"));
        Properties dbProperties = DataSourceHelper.getDataSourceProperties((String)SPECIFIC_PREFIX, (String)"org.eclipse.scada.jdbc");
        String schema = this.getSchema();
        String instance = this.getInstance();
        this.jdbcStorage = new JdbcStorage(dataSourceFactory, this.scheduler, dbProperties, DataSourceHelper.isConnectionPool((String)SPECIFIC_PREFIX, (String)"org.eclipse.scada.jdbc", (boolean)false), schema, instance);
        this.jdbcStorage.start();
        Hashtable<String, String> properties = new Hashtable<String, String>(2);
        ((Dictionary)properties).put("service.description", "PostgreSQL specific JDBC implementation for org.eclipse.scada.ae.server.storage.Storage");
        ((Dictionary)properties).put("service.vendor", "Eclipse SCADA Project");
        this.jdbcStorageHandle = context.registerService(new String[]{JdbcStorage.class.getName(), Storage.class.getName()}, (Object)this.jdbcStorage, properties);
    }

    private String getSchema() {
        if (!System.getProperty("org.eclipse.scada.ae.server.storage.jdbc.schema", "").trim().isEmpty()) {
            return String.valueOf(System.getProperty("org.eclipse.scada.ae.server.storage.jdbc.schema")) + ".";
        }
        return "";
    }

    private String getInstance() {
        return System.getProperty("org.eclipse.scada.ae.server.storage.jdbc.instance", "default");
    }

    private void deactivate() throws Exception {
        if (this.scheduler != null) {
            this.scheduler.shutdownNow();
        }
        if (this.jdbcStorageHandle != null) {
            this.jdbcStorageHandle.unregister();
            this.jdbcStorageHandle = null;
        }
        if (this.jdbcStorage != null) {
            this.jdbcStorage.dispose();
            this.jdbcStorage = null;
        }
    }

    public void stop(BundleContext bundleContext) throws Exception {
        if (this.dataSouceFactoryTracker != null) {
            this.dataSouceFactoryTracker.close();
        }
        this.deactivate();
        context = null;
    }
}

