/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.da.mapper.osgi.jdbc;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.locks.ReentrantLock;
import org.eclipse.scada.ca.ConfigurationDataHelper;
import org.eclipse.scada.core.Variant;
import org.eclipse.scada.core.VariantEditor;
import org.eclipse.scada.da.mapper.AbstractValueMapper;
import org.eclipse.scada.da.mapper.ValueMapper;
import org.eclipse.scada.da.mapper.osgi.jdbc.JdbcValueMapperState;
import org.eclipse.scada.da.server.common.DataItem;
import org.eclipse.scada.da.server.common.DataItemCommand;
import org.eclipse.scada.da.server.common.exporter.ObjectExporter;
import org.eclipse.scada.da.server.common.item.factory.ItemFactory;
import org.eclipse.scada.da.server.common.osgi.factory.ObjectPoolDataItemFactory;
import org.eclipse.scada.utils.concurrent.NamedThreadFactory;
import org.eclipse.scada.utils.osgi.jdbc.DataSourceConnectionAccessor;
import org.eclipse.scada.utils.osgi.jdbc.DataSourceFactoryTracker;
import org.eclipse.scada.utils.osgi.jdbc.task.CommonConnectionTask;
import org.eclipse.scada.utils.osgi.jdbc.task.ConnectionContext;
import org.eclipse.scada.utils.osgi.jdbc.task.ConnectionTask;
import org.eclipse.scada.utils.osgi.jdbc.task.RowCallback;
import org.eclipse.scada.utils.osgi.pool.ManageableObjectPool;
import org.osgi.framework.BundleContext;
import org.osgi.service.jdbc.DataSourceFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JdbcValueMapper
extends AbstractValueMapper
implements ValueMapper {
    private static final Logger logger = LoggerFactory.getLogger(JdbcValueMapper.class);
    private final ScheduledExecutorService executor;
    private volatile Configuration configuration;
    private final BundleContext context;
    private final JdbcValueMapperState state;
    private final String id;
    private final ManageableObjectPool<DataItem> objectPool;
    private ObjectExporter exporter;
    private ObjectPoolDataItemFactory itemFactory;
    private final ReentrantLock updateLock;

    public JdbcValueMapper(BundleContext context, String id, ManageableObjectPool<DataItem> objectPool) {
        this.id = id;
        this.objectPool = objectPool;
        this.context = context;
        this.executor = Executors.newSingleThreadScheduledExecutor((ThreadFactory)new NamedThreadFactory("org.eclipse.scada.da.mapper.osgi.jdbc"));
        this.state = new JdbcValueMapperState();
        this.updateLock = new ReentrantLock();
    }

    public void dispose() {
        this.disposeStateExporter();
        this.executor.shutdown();
        super.dispose();
    }

    public void update(Map<String, String> parameters) {
        try {
            this.updateLock.lock();
            this.disposeStateExporter();
            ConfigurationDataHelper cfg = new ConfigurationDataHelper(parameters);
            Configuration configuration = new Configuration();
            configuration.defaultValue = this.makeDefaultValue(cfg);
            configuration.jdbcDriver = cfg.getStringChecked("jdbcDriver", "'jdbcDriver' must be set");
            configuration.jdbcProperties = new Properties();
            configuration.jdbcProperties.putAll((Map<?, ?>)cfg.getPrefixed("properties."));
            configuration.loginTimeout = cfg.getInteger("loginTimeout", 5);
            configuration.serviceTimeout = cfg.getInteger("serviceTimeout", 1000);
            configuration.statePrefix = cfg.getString("statePrefix", String.format("datamapper.%s.", this.id));
            configuration.sql = cfg.getStringChecked("sql", "'sql' is required");
            this.configuration = configuration;
            this.createStateExporter();
            this.startUpdate();
        }
        finally {
            this.updateLock.unlock();
        }
    }

    private void createStateExporter() {
        this.itemFactory = new ObjectPoolDataItemFactory((Executor)this.executor, this.objectPool, this.configuration.statePrefix);
        this.exporter = new ObjectExporter((ItemFactory)this.itemFactory, false, false);
        this.exporter.attachTarget((Object)this.state);
        DataItemCommand reloadCommand = this.itemFactory.createCommand("reload", null);
        reloadCommand.addListener(new DataItemCommand.Listener(){

            public void command(Variant value) throws Exception {
                JdbcValueMapper.this.startUpdate();
            }
        });
    }

    private void disposeStateExporter() {
        if (this.exporter != null) {
            this.exporter.dispose();
            this.exporter = null;
        }
        if (this.itemFactory != null) {
            this.itemFactory.dispose();
            this.itemFactory = null;
        }
    }

    private void startUpdate() {
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    try {
                        JdbcValueMapper.this.state.setLoading(true);
                        JdbcValueMapper.this.performReload();
                    }
                    catch (Exception e) {
                        JdbcValueMapper.this.handleError(e);
                        JdbcValueMapper.this.state.setLoading(false);
                    }
                }
                finally {
                    JdbcValueMapper.this.state.setLoading(false);
                }
            }
        });
    }

    protected void handleError(Exception e) {
        logger.warn("Failed to load data", (Throwable)e);
        super.configure(Collections.emptyMap(), this.configuration.defaultValue);
        this.state.setError(true);
        this.state.setEntries(0);
    }

    protected void performReload() throws Exception {
        Map newData;
        final Configuration configuration = this.configuration;
        DataSourceFactoryTracker tracker = new DataSourceFactoryTracker(this.context, configuration.jdbcDriver, null);
        try {
            tracker.open();
            DataSourceFactory factory = (DataSourceFactory)tracker.waitForService((long)configuration.serviceTimeout);
            DataSourceConnectionAccessor accessor = new DataSourceConnectionAccessor(factory, configuration.jdbcProperties);
            accessor.getDataSource().setLoginTimeout(configuration.loginTimeout);
            newData = (Map)accessor.doWithConnection((ConnectionTask)new CommonConnectionTask<Map<String, String>>(){

                protected Map<String, String> performTask(ConnectionContext connectionContext) throws Exception {
                    return JdbcValueMapper.this.doReload(configuration, connectionContext);
                }
            });
        }
        finally {
            tracker.close();
        }
        this.configure(newData, configuration.defaultValue);
    }

    protected void configure(Map<String, String> data, Variant defaultValue) {
        super.configure(data, defaultValue);
        this.state.setError(false);
        this.state.setEntries(data.size());
    }

    protected Map<String, String> doReload(Configuration configuration, ConnectionContext connectionContext) throws SQLException {
        final HashMap<String, String> result = new HashMap<String, String>();
        connectionContext.query(new RowCallback(){

            public void processRow(ResultSet resultSet) throws SQLException {
                String key = resultSet.getString(1);
                String value = resultSet.getString(2);
                result.put(key, value);
            }
        }, configuration.sql, new Object[0]);
        return result;
    }

    private Variant makeDefaultValue(ConfigurationDataHelper cfg) {
        String stringValue = cfg.getString("defaultValue", null);
        if (stringValue == null) {
            return null;
        }
        return VariantEditor.toVariant((String)stringValue);
    }

    private static class Configuration {
        Variant defaultValue;
        String jdbcDriver;
        String sql;
        Properties jdbcProperties;
        public int loginTimeout;
        public int serviceTimeout;
        public String statePrefix;

        private Configuration() {
        }
    }
}

