/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.ae.server.injector.internal;

import org.eclipse.scada.ae.server.handler.EventHandlerFactory;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

public class EventHandlerFactoryTracker {
    private final Listener listener;
    private final ServiceTrackerCustomizer<EventHandlerFactory, EventHandlerFactory> customizer = new ServiceTrackerCustomizer<EventHandlerFactory, EventHandlerFactory>(){

        public void removedService(ServiceReference<EventHandlerFactory> reference, EventHandlerFactory service) {
            EventHandlerFactoryTracker.this.handleRemoved(reference, service);
        }

        public void modifiedService(ServiceReference<EventHandlerFactory> reference, EventHandlerFactory service) {
        }

        public EventHandlerFactory addingService(ServiceReference<EventHandlerFactory> reference) {
            return EventHandlerFactoryTracker.this.handleAdding(reference);
        }
    };
    private final ServiceTracker<EventHandlerFactory, EventHandlerFactory> tracker;
    private final BundleContext context;

    public EventHandlerFactoryTracker(BundleContext context, Listener listener) {
        this.context = context;
        this.listener = listener;
        this.tracker = new ServiceTracker(context, EventHandlerFactory.class, this.customizer);
        this.tracker.open();
    }

    public void dispose() {
        this.tracker.close();
    }

    protected EventHandlerFactory handleAdding(ServiceReference<EventHandlerFactory> reference) {
        String factoryId = EventHandlerFactoryTracker.getFactoryId(reference);
        if (factoryId == null) {
            return null;
        }
        EventHandlerFactory factory = (EventHandlerFactory)this.context.getService(reference);
        if (this.listener != null) {
            this.listener.factoryAdded(factoryId, factory);
        }
        return factory;
    }

    protected void handleRemoved(ServiceReference<EventHandlerFactory> reference, EventHandlerFactory service) {
        String factoryId = EventHandlerFactoryTracker.getFactoryId(reference);
        if (factoryId == null) {
            return;
        }
        if (this.listener != null) {
            this.listener.factoryRemoved(factoryId);
        }
    }

    private static String getFactoryId(ServiceReference<EventHandlerFactory> reference) {
        Object o = reference.getProperty("event.handler.factory.id");
        if (o instanceof String) {
            return (String)o;
        }
        return null;
    }

    public static interface Listener {
        public void factoryAdded(String var1, EventHandlerFactory var2);

        public void factoryRemoved(String var1);
    }
}

