/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.ae.slave.pull;

import java.util.Properties;

public class Site {
    private final String id;
    private final String driverName;
    private final Properties properties;
    private final long delay;
    private long lastProcess;
    private final String schema;
    private final String customSelectSql;
    private final String customDeleteSql;

    public Site(String id, String driverName, Properties properties, String schema, long delay, String customSelectSql, String customDeleteSql) {
        this.id = id;
        this.driverName = driverName;
        this.properties = properties;
        this.schema = schema;
        this.delay = delay;
        this.customSelectSql = customSelectSql;
        this.customDeleteSql = customDeleteSql;
    }

    public String getCustomDeleteSql() {
        return this.customDeleteSql;
    }

    public String getCustomSelectSql() {
        return this.customSelectSql;
    }

    public String getSchema() {
        return this.schema;
    }

    public long nextStart() {
        return this.lastProcess + this.delay;
    }

    public boolean isDue() {
        return System.currentTimeMillis() - this.lastProcess > this.delay;
    }

    public void markProcessed() {
        this.lastProcess = System.currentTimeMillis();
    }

    public void setLastProcess(long lastProcess) {
        this.lastProcess = lastProcess;
    }

    public long getLastProcess() {
        return this.lastProcess;
    }

    public String getId() {
        return this.id;
    }

    public String getDriverName() {
        return this.driverName;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Site other = (Site)obj;
        return !(this.id == null ? other.id != null : !this.id.equals(other.id));
    }
}

