/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.sec.osgi.manager;

import org.eclipse.scada.sec.AuthorizationService;
import org.eclipse.scada.sec.osgi.manager.AuthorizationManagerImpl;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTrackerCustomizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class ServiceTrackerCustomizerImplementation
implements ServiceTrackerCustomizer<AuthorizationService, AuthorizationService> {
    private static final Logger logger = LoggerFactory.getLogger(ServiceTrackerCustomizerImplementation.class);
    private final AuthorizationManagerImpl authorizationManagerImpl;
    private final BundleContext context;

    public ServiceTrackerCustomizerImplementation(AuthorizationManagerImpl authorizationManagerImpl, BundleContext context) {
        this.authorizationManagerImpl = authorizationManagerImpl;
        this.context = context;
    }

    private String[] getServiceTypes(ServiceReference<AuthorizationService> reference) {
        Object t = reference.getProperty("rule.types");
        if (t instanceof String[]) {
            return (String[])t;
        }
        if (t instanceof String) {
            return new String[]{(String)t};
        }
        return null;
    }

    public AuthorizationService addingService(ServiceReference<AuthorizationService> reference) {
        String[] serviceTypes = this.getServiceTypes(reference);
        AuthorizationService service = (AuthorizationService)this.context.getService(reference);
        this.authorizationManagerImpl.addService(service, serviceTypes);
        return service;
    }

    public void modifiedService(ServiceReference<AuthorizationService> reference, AuthorizationService service) {
        this.authorizationManagerImpl.removeService(service);
        String[] serviceTypes = this.getServiceTypes(reference);
        this.authorizationManagerImpl.addService(service, serviceTypes);
    }

    public void removedService(ServiceReference<AuthorizationService> reference, AuthorizationService service) {
        try {
            this.authorizationManagerImpl.removeService(service);
        }
        catch (Exception e) {
            logger.warn("Failed to remove service", (Throwable)e);
        }
        this.context.ungetService(reference);
    }
}

