/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.da.server.common.osgi;

import java.util.Properties;
import java.util.Set;
import java.util.concurrent.Executor;
import org.eclipse.scada.core.server.common.osgi.SessionPrivilegeTracker;
import org.eclipse.scada.core.server.common.session.AbstractSessionImpl;
import org.eclipse.scada.core.server.common.session.PrivilegeListenerImpl;
import org.eclipse.scada.da.server.common.impl.HiveCommon;
import org.eclipse.scada.sec.AuthenticationImplementation;
import org.eclipse.scada.sec.AuthorizationImplementation;
import org.eclipse.scada.sec.UserInformation;
import org.eclipse.scada.sec.audit.AuditLogService;
import org.eclipse.scada.sec.osgi.AuthorizationTracker;
import org.eclipse.scada.sec.osgi.TrackingAuditLogImplementation;
import org.eclipse.scada.sec.osgi.TrackingAuthenticationImplementation;
import org.eclipse.scada.sec.osgi.TrackingAuthorizationImplementation;
import org.eclipse.scada.sec.osgi.TrackingAuthorizationTracker;
import org.osgi.framework.BundleContext;

public abstract class AbstractOsgiHiveCommon
extends HiveCommon {
    private final BundleContext context;
    private TrackingAuthenticationImplementation authenticationImplementation;
    private TrackingAuthorizationImplementation authorizationManager;
    private TrackingAuthorizationTracker authorizationTracker;
    private TrackingAuditLogImplementation auditLogTracker;
    private final Executor executor;

    public AbstractOsgiHiveCommon(BundleContext context) {
        this(context, null);
    }

    public AbstractOsgiHiveCommon(BundleContext context, Executor executor) {
        this.context = context;
        this.executor = executor;
        if (context != null) {
            this.authenticationImplementation = new TrackingAuthenticationImplementation(context);
            this.authorizationManager = new TrackingAuthorizationImplementation(context);
            this.authorizationTracker = new TrackingAuthorizationTracker(context);
            this.auditLogTracker = new TrackingAuditLogImplementation(context);
            this.setAuthenticationImplementation((AuthenticationImplementation)this.authenticationImplementation);
            this.setAuthorizationImplementation((AuthorizationImplementation)this.authorizationManager);
            this.setAuditLogService((AuditLogService)this.auditLogTracker);
        }
    }

    protected void handleSessionCreated(AbstractSessionImpl session, Properties properties, UserInformation userInformation) {
        super.handleSessionCreated(session, properties, userInformation);
        Executor executor = this.executor != null ? this.executor : this.getOperationService();
        Set privileges = this.extractPrivileges(properties);
        final SessionPrivilegeTracker privTracker = new SessionPrivilegeTracker(executor, (SessionPrivilegeTracker.PrivilegeListener)new PrivilegeListenerImpl(session), (AuthorizationTracker)this.authorizationTracker, privileges, userInformation);
        session.addDisposeListener(new AbstractSessionImpl.DisposeListener(){

            public void disposed() {
                privTracker.dispose();
            }
        });
    }

    protected void performStart() throws Exception {
        super.performStart();
        if (this.context != null) {
            this.authorizationManager.open();
            this.authorizationTracker.open();
            this.authenticationImplementation.open();
            this.auditLogTracker.open();
        }
    }

    protected void performStop() throws Exception {
        if (this.context != null) {
            this.auditLogTracker.close();
            this.authenticationImplementation.close();
            this.authorizationTracker.close();
            this.authorizationManager.close();
        }
        super.performStop();
    }
}

