/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.da.server.osgi.internal;

import java.util.Dictionary;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.Executor;
import org.eclipse.scada.core.Variant;
import org.eclipse.scada.core.server.common.osgi.SessionPrivilegeTracker;
import org.eclipse.scada.core.server.common.session.AbstractSessionImpl;
import org.eclipse.scada.core.server.common.session.PrivilegeListenerImpl;
import org.eclipse.scada.da.server.browser.common.Folder;
import org.eclipse.scada.da.server.browser.common.FolderCommon;
import org.eclipse.scada.da.server.browser.common.query.GroupFolder;
import org.eclipse.scada.da.server.browser.common.query.GroupProvider;
import org.eclipse.scada.da.server.browser.common.query.IDNameProvider;
import org.eclipse.scada.da.server.browser.common.query.InvisibleStorage;
import org.eclipse.scada.da.server.browser.common.query.ItemDescriptor;
import org.eclipse.scada.da.server.browser.common.query.ItemStorage;
import org.eclipse.scada.da.server.browser.common.query.NameProvider;
import org.eclipse.scada.da.server.browser.common.query.SplitGroupProvider;
import org.eclipse.scada.da.server.browser.common.query.SplitNameProvider;
import org.eclipse.scada.da.server.common.DataItem;
import org.eclipse.scada.da.server.common.ValidationStrategy;
import org.eclipse.scada.da.server.common.impl.HiveCommon;
import org.eclipse.scada.sec.AuthenticationImplementation;
import org.eclipse.scada.sec.AuthorizationImplementation;
import org.eclipse.scada.sec.UserInformation;
import org.eclipse.scada.sec.audit.AuditLogService;
import org.eclipse.scada.sec.osgi.AuthorizationTracker;
import org.eclipse.scada.sec.osgi.TrackingAuditLogImplementation;
import org.eclipse.scada.sec.osgi.TrackingAuthenticationImplementation;
import org.eclipse.scada.sec.osgi.TrackingAuthorizationImplementation;
import org.eclipse.scada.sec.osgi.TrackingAuthorizationTracker;
import org.eclipse.scada.utils.collection.MapBuilder;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HiveImpl
extends HiveCommon {
    private static final Logger logger = LoggerFactory.getLogger(HiveImpl.class);
    private FolderCommon rootFolder;
    private final BundleContext context;
    private final InvisibleStorage storage;
    private final Map<ServiceReference<?>, ItemDescriptor> items;
    private final TrackingAuthorizationImplementation authorizationManager;
    private final TrackingAuthorizationTracker authorizationTracker;
    private final Executor executor;
    private final TrackingAuthenticationImplementation authenticationImplementation;
    private final TrackingAuditLogImplementation auditLogTracker;

    public HiveImpl(BundleContext context, Executor executor) throws InvalidSyntaxException {
        this.context = context;
        this.executor = executor;
        this.authenticationImplementation = new TrackingAuthenticationImplementation(context);
        this.authorizationManager = new TrackingAuthorizationImplementation(context);
        this.authorizationTracker = new TrackingAuthorizationTracker(context);
        this.auditLogTracker = new TrackingAuditLogImplementation(context);
        this.setAuthenticationImplementation((AuthenticationImplementation)this.authenticationImplementation);
        this.setAuthorizationImplementation((AuthorizationImplementation)this.authorizationManager);
        this.setAuditLogService((AuditLogService)this.auditLogTracker);
        this.setValidatonStrategy(ValidationStrategy.GRANT_ALL);
        this.rootFolder = new FolderCommon();
        this.setRootFolder((Folder)this.rootFolder);
        this.items = new HashMap();
        this.storage = new InvisibleStorage();
        GroupFolder allItemsFolder = new GroupFolder((GroupProvider)new SplitGroupProvider((NameProvider)new IDNameProvider(), "\\.", 0, 2), (NameProvider)new SplitNameProvider((NameProvider)new IDNameProvider(), "\\.", 0, 2, "."));
        this.rootFolder.add("all", (Folder)allItemsFolder, new MapBuilder().put((Object)"description", (Object)Variant.valueOf((Object)"A folder containing the full item space")).getMap());
        this.storage.addChild((ItemStorage)allItemsFolder);
    }

    public String getHiveId() {
        return "org.eclipse.scada.da.server.osgi";
    }

    protected void performStart() throws Exception {
        this.authorizationManager.open();
        this.authorizationTracker.open();
        this.authenticationImplementation.open();
        this.auditLogTracker.open();
        super.performStart();
    }

    protected void performStop() throws Exception {
        super.performStop();
        this.auditLogTracker.close();
        this.authenticationImplementation.close();
        this.authorizationTracker.close();
        this.authorizationManager.close();
    }

    protected void handleSessionCreated(AbstractSessionImpl session, Properties properties, UserInformation userInformation) {
        super.handleSessionCreated(session, properties, userInformation);
        Set privileges = this.extractPrivileges(properties);
        final SessionPrivilegeTracker privTracker = new SessionPrivilegeTracker(this.executor, (SessionPrivilegeTracker.PrivilegeListener)new PrivilegeListenerImpl(session), (AuthorizationTracker)this.authorizationTracker, privileges, userInformation);
        session.addDisposeListener(new AbstractSessionImpl.DisposeListener(){

            public void disposed() {
                privTracker.dispose();
            }
        });
    }

    public synchronized void addItem(DataItem item, Dictionary<?, ?> properties) {
        this.registerItem(item);
        HashMap<String, Variant> attributes = new HashMap<String, Variant>(0);
        HiveImpl.fillAttributes(attributes, properties);
        ItemDescriptor descriptor = new ItemDescriptor(item, attributes);
        this.storage.added(descriptor);
    }

    private static void fillAttributes(Map<String, Variant> attributes, Dictionary<?, ?> properties) {
        if (properties == null) {
            return;
        }
        Object description = properties.get("service.description");
        if (description != null) {
            attributes.put("description", Variant.valueOf(description));
        }
    }

    public synchronized void removeItem(DataItem item) {
        this.unregisterItem(item);
        this.storage.removed(new ItemDescriptor(item, null));
    }

    public synchronized void addItem(ServiceReference<?> serviceReference) {
        if (!serviceReference.isAssignableTo(this.context.getBundle(), DataItem.class.getName())) {
            return;
        }
        DataItem item = (DataItem)this.context.getService(serviceReference);
        this.registerItem(item);
        HashMap attributes = new HashMap(0);
        ItemDescriptor descriptor = new ItemDescriptor(item, attributes);
        this.storage.added(descriptor);
        this.items.put(serviceReference, descriptor);
        logger.info("Exporting {} as {}", serviceReference, (Object)item.getInformation().getName());
    }

    public synchronized void removeItem(ServiceReference<?> serviceReference) {
        logger.info("Removing {}", serviceReference);
        this.context.ungetService(serviceReference);
        ItemDescriptor descriptor = this.items.remove(serviceReference);
        this.storage.removed(descriptor);
        this.unregisterItem(descriptor.getItem());
    }
}

