/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.ae.server.common.monitor;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;
import org.eclipse.scada.ae.data.MonitorStatusInformation;
import org.eclipse.scada.ae.server.common.monitor.MonitorQueryListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MonitorQuery {
    private static final Logger logger = LoggerFactory.getLogger(MonitorQuery.class);
    private final Set<MonitorQueryListener> listeners;
    private final Map<String, MonitorStatusInformation> cachedData;
    private final Executor executor;

    public MonitorQuery(Executor executor) {
        this.executor = executor;
        this.cachedData = new HashMap<String, MonitorStatusInformation>();
        this.listeners = new LinkedHashSet<MonitorQueryListener>();
    }

    public synchronized void addListener(MonitorQueryListener listener) {
        if (this.listeners.add(listener)) {
            listener.dataChanged(new ArrayList<MonitorStatusInformation>(this.cachedData.values()), null, true);
        }
    }

    public synchronized void removeListener(MonitorQueryListener listener) {
        this.listeners.remove(listener);
    }

    private synchronized void fireListener(final List<MonitorStatusInformation> addedOrUpdated, final Set<String> removed, final boolean full) {
        for (final MonitorQueryListener listener : this.listeners) {
            this.executor.execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        listener.dataChanged(addedOrUpdated, removed, full);
                    }
                    catch (Exception e) {
                        logger.warn("Failed to notify", (Throwable)e);
                    }
                }
            });
        }
    }

    protected synchronized void updateData(List<MonitorStatusInformation> data, Set<String> removed, boolean full) {
        if (full) {
            this.cachedData.clear();
        }
        if (data != null) {
            for (MonitorStatusInformation info : data) {
                this.cachedData.put(info.getId(), info);
            }
        }
        HashSet<String> removedItems = new HashSet<String>();
        if (removed != null) {
            for (String entry : removed) {
                if (this.cachedData.remove(entry) == null) continue;
                removedItems.add(entry);
            }
        }
        this.fireListener(data, removedItems, full);
    }

    public synchronized void dispose() {
        this.clear();
        this.listeners.clear();
    }

    protected synchronized void setData(MonitorStatusInformation[] data) {
        logger.debug("Set new data: {}", (Object)data.length);
        this.clear();
        ArrayList<MonitorStatusInformation> newData = new ArrayList<MonitorStatusInformation>(data.length);
        MonitorStatusInformation[] monitorStatusInformationArray = data;
        int n = data.length;
        int n2 = 0;
        while (n2 < n) {
            MonitorStatusInformation ci = monitorStatusInformationArray[n2];
            newData.add(ci);
            MonitorStatusInformation oldCi = this.cachedData.put(ci.getId(), ci);
            if (oldCi != null) {
                newData.remove(oldCi);
            }
            ++n2;
        }
        this.fireListener(newData, null, true);
    }

    protected synchronized void clear() {
        this.fireListener(null, null, true);
        this.cachedData.clear();
    }
}

