/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.ae.server.exporter.net;

import org.eclipse.scada.ae.server.Service;
import org.eclipse.scada.ae.server.net.Exporter;
import org.eclipse.scada.core.ConnectionInformation;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Activator
implements BundleActivator {
    private static final Logger logger = LoggerFactory.getLogger(Activator.class);
    private ServiceListener listener;
    private ServiceReference<?> currentServiceReference;
    private BundleContext context;
    private final ConnectionInformation connectionInformation = ConnectionInformation.fromURI((String)System.getProperty("org.eclipse.scada.ae.server.exporter.net.exportUri", "ae:net://0.0.0.0:1302"));
    private Exporter exporter;
    private Service currentService;

    public void start(BundleContext context) throws Exception {
        this.context = context;
        this.listener = new ServiceListener(){

            public void serviceChanged(ServiceEvent event) {
                switch (event.getType()) {
                    case 1: {
                        Activator.this.startExporter(event.getServiceReference());
                        break;
                    }
                    case 4: {
                        Activator.this.stopExporter(event.getServiceReference());
                    }
                }
            }
        };
        context.addServiceListener(this.listener, "(objectClass=" + Service.class.getName() + ")");
        this.startExporter(context.getServiceReference(Service.class.getName()));
    }

    protected void stopExporter(ServiceReference<?> serviceReference) {
        if (this.currentServiceReference != serviceReference) {
            return;
        }
        try {
            try {
                this.exporter.stop();
            }
            catch (Throwable e) {
                logger.warn("Failed to stop", e);
                if (this.currentServiceReference != null) {
                    this.context.ungetService(this.currentServiceReference);
                }
                this.currentService = null;
                this.exporter = null;
                this.currentServiceReference = null;
            }
        }
        finally {
            if (this.currentServiceReference != null) {
                this.context.ungetService(this.currentServiceReference);
            }
            this.currentService = null;
            this.exporter = null;
            this.currentServiceReference = null;
        }
    }

    protected void startExporter(ServiceReference<?> serviceReference) {
        if (this.currentServiceReference != null || serviceReference == null) {
            return;
        }
        Object o = this.context.getService(serviceReference);
        if (o instanceof Service) {
            try {
                logger.info("Exporting: {}", serviceReference);
                this.currentService = (Service)o;
                this.exporter = new Exporter(this.currentService, this.connectionInformation);
                this.exporter.start();
            }
            catch (Throwable e) {
                logger.warn("Failed to start", e);
                this.exporter = null;
                this.currentService = null;
                this.context.ungetService(serviceReference);
            }
        } else {
            this.context.ungetService(serviceReference);
        }
    }

    public void stop(BundleContext context) throws Exception {
        context.removeServiceListener(this.listener);
        this.stopExporter(this.currentServiceReference);
        this.context = null;
    }
}

