/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.da.server.exporter.rest.internal;

import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ScheduledExecutorService;
import org.eclipse.scada.ca.ConfigurationDataHelper;
import org.eclipse.scada.core.Variant;
import org.eclipse.scada.da.client.DataItemValue;
import org.eclipse.scada.da.core.WriteAttributeResults;
import org.eclipse.scada.da.core.WriteResult;
import org.eclipse.scada.da.server.exporter.common.AggregatingSubscriptionManager;
import org.eclipse.scada.da.server.exporter.common.HiveSource;
import org.eclipse.scada.utils.concurrent.NotifyFuture;

public class DataContext {
    private final AggregatingSubscriptionManager subscriptionManager;

    public DataContext(ScheduledExecutorService executor, HiveSource hiveSource, Map<String, String> properties, String logName) {
        ConfigurationDataHelper cfg = new ConfigurationDataHelper(properties);
        Properties hiveProperties = cfg.getPrefixedProperties("hive.");
        this.subscriptionManager = new AggregatingSubscriptionManager(executor, hiveSource, hiveProperties, logName);
        this.subscriptionManager.start();
        this.subscriptionManager.subscribeAll(cfg.getStringSet("items."));
    }

    public DataItemValue getValue(String itemId) {
        return this.subscriptionManager.getCacheValue(itemId);
    }

    public NotifyFuture<WriteResult> writeValue(String itemId, Variant value) {
        return this.subscriptionManager.writeValue(itemId, value, null, null);
    }

    public NotifyFuture<WriteAttributeResults> writeAttributes(String itemId, Map<String, Variant> attributes) {
        return this.subscriptionManager.writeAttributes(itemId, attributes, null, null);
    }

    public void dispose() {
        this.subscriptionManager.stop();
    }
}

