/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.core.subscription;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.scada.core.subscription.Subscription;
import org.eclipse.scada.core.subscription.SubscriptionListener;
import org.eclipse.scada.core.subscription.SubscriptionSource;
import org.eclipse.scada.core.subscription.SubscriptionValidator;
import org.eclipse.scada.core.subscription.ValidationException;

public class SubscriptionManager<T> {
    private final Map<T, Subscription<T>> subscriptions = new HashMap<T, Subscription<T>>();
    private final SubscriptionValidator<T> validator;

    public SubscriptionManager(SubscriptionValidator<T> validator) {
        this.validator = validator;
    }

    public SubscriptionManager() {
        this.validator = null;
    }

    public synchronized void unsubscribeAll(SubscriptionListener<T> listener) {
        Iterator<Map.Entry<T, Subscription<T>>> i = this.subscriptions.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry<T, Subscription<T>> entry = i.next();
            entry.getValue().unsubscribe(listener);
            if (!entry.getValue().isEmpty()) continue;
            i.remove();
        }
    }

    public synchronized void subscribe(T topic, SubscriptionListener<T> listener) throws ValidationException {
        this.subscribe(topic, listener, null);
    }

    public synchronized void subscribe(T topic, SubscriptionListener<T> listener, Object hint) throws ValidationException {
        if (this.validator != null && !this.validator.validate(listener, topic)) {
            throw new ValidationException();
        }
        Subscription<T> s = this.subscriptions.get(topic);
        if (s == null) {
            s = new Subscription<T>(topic);
            this.subscriptions.put(topic, s);
        }
        boolean wasSubscribed = s.isSubscribed();
        s.subscribe(listener, hint);
        if (!wasSubscribed && s.isSubscribed()) {
            this.topicSubscriptionAdded(topic);
        }
    }

    public synchronized void unsubscribe(T topic, SubscriptionListener<T> listener) {
        Subscription<T> s = this.subscriptions.get(topic);
        if (s == null) {
            return;
        }
        boolean wasSubscribed = s.isSubscribed();
        s.unsubscribe(listener);
        if (wasSubscribed && !s.isSubscribed()) {
            this.topicSubscriptionRemoved(topic);
        }
        if (s.isEmpty()) {
            this.subscriptions.remove(topic);
        }
    }

    protected void topicSubscriptionAdded(T topic) {
    }

    protected void topicSubscriptionRemoved(T topic) {
    }

    public synchronized void setSource(T topic, SubscriptionSource<T> source) {
        Subscription<T> s = this.subscriptions.get(topic);
        if (s == null && source == null) {
            return;
        }
        if (s == null) {
            s = new Subscription<T>(topic);
            this.subscriptions.put(topic, s);
        }
        s.setSource(source);
        if (s.isEmpty()) {
            this.subscriptions.remove(topic);
        }
    }

    public synchronized int getSubscriptionCount() {
        return this.subscriptions.size();
    }

    public synchronized Set<T> getAllGrantedTopics() {
        HashSet<T> topicList = new HashSet<T>();
        for (Map.Entry<T, Subscription<T>> entry : this.subscriptions.entrySet()) {
            if (!entry.getValue().isGranted()) continue;
            topicList.add(entry.getKey());
        }
        return topicList;
    }
}

