/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.ae.server.common.monitor.internal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;
import org.eclipse.scada.ae.data.MonitorStatusInformation;
import org.eclipse.scada.ae.monitor.MonitorListener;
import org.eclipse.scada.ae.monitor.MonitorService;
import org.eclipse.scada.ae.server.common.monitor.MonitorQuery;
import org.eclipse.scada.utils.filter.Filter;
import org.eclipse.scada.utils.filter.FilterParser;
import org.eclipse.scada.utils.filter.bean.BeanMatcher;
import org.eclipse.scada.utils.osgi.pool.AllObjectPoolServiceTracker;
import org.eclipse.scada.utils.osgi.pool.ObjectPoolListener;
import org.eclipse.scada.utils.osgi.pool.ObjectPoolTracker;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BundleMonitorQuery
extends MonitorQuery
implements MonitorListener {
    private static final Logger logger = LoggerFactory.getLogger(BundleMonitorQuery.class);
    private final Set<MonitorService> services = new HashSet<MonitorService>();
    private final AllObjectPoolServiceTracker<MonitorService> tracker;
    private final Map<String, MonitorStatusInformation> cachedData = new HashMap<String, MonitorStatusInformation>();
    private Filter filter = Filter.EMPTY;

    public BundleMonitorQuery(Executor executor, BundleContext context, ObjectPoolTracker<MonitorService> poolTracker) throws InvalidSyntaxException {
        super(executor);
        this.tracker = new AllObjectPoolServiceTracker(poolTracker, (ObjectPoolListener)new ObjectPoolListener<MonitorService>(){

            public void serviceRemoved(MonitorService service, Dictionary<?, ?> properties) {
                BundleMonitorQuery.this.handleRemoved(service);
            }

            public void serviceModified(MonitorService service, Dictionary<?, ?> properties) {
            }

            public void serviceAdded(MonitorService service, Dictionary<?, ?> properties) {
                BundleMonitorQuery.this.handleAdded(service);
            }
        });
        this.tracker.open();
    }

    protected synchronized void handleAdded(MonitorService service) {
        if (this.services.add(service)) {
            service.addStatusListener((MonitorListener)this);
        }
    }

    protected synchronized void handleRemoved(MonitorService service) {
        if (this.services.remove(service)) {
            service.removeStatusListener((MonitorListener)this);
            this.cachedData.remove(service.getId());
            this.updateData(null, Collections.singleton(service.getId()), false);
        }
    }

    public void update(Map<String, String> parameters) {
        String filterStr = parameters.get("filter");
        logger.debug("Setting new filter: {}", (Object)filterStr);
        FilterParser parser = new FilterParser(filterStr);
        this.setFilter(parser.getFilter());
    }

    protected synchronized void setFilter(Filter filter) {
        logger.debug("SetFilter: {}", (Object)filter);
        this.filter = filter == null ? Filter.EMPTY : filter;
        this.setData(this.getFiltered());
    }

    protected synchronized MonitorStatusInformation[] getFiltered() {
        ArrayList<MonitorStatusInformation> result = new ArrayList<MonitorStatusInformation>();
        for (MonitorStatusInformation ci : this.cachedData.values()) {
            if (!this.matchesFilter(ci)) continue;
            result.add(ci);
        }
        return result.toArray(new MonitorStatusInformation[result.size()]);
    }

    private boolean matchesFilter(MonitorStatusInformation status) {
        return BeanMatcher.matches((Filter)this.filter, (Object)status, (boolean)true, null);
    }

    public synchronized void dispose() {
        super.dispose();
        for (MonitorService service : this.services) {
            service.removeStatusListener((MonitorListener)this);
        }
        this.services.clear();
        this.tracker.close();
    }

    public synchronized void statusChanged(MonitorStatusInformation status) {
        logger.debug("Status changed: {}", (Object)status);
        this.cachedData.put(status.getId(), status);
        if (this.matchesFilter(status)) {
            this.updateData(Arrays.asList(status), null, false);
        } else {
            this.updateData(null, Collections.singleton(status.getId()), false);
        }
    }
}

