/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.hd.server.storage.common;

import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.Executor;
import org.eclipse.scada.hd.QueryListener;
import org.eclipse.scada.hd.QueryState;
import org.eclipse.scada.hd.data.QueryParameters;
import org.eclipse.scada.hd.server.storage.common.DataFactory;
import org.eclipse.scada.hd.server.storage.common.QueryDataBuffer;
import org.eclipse.scada.hd.server.storage.common.RunningAverage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryBuffer
extends QueryDataBuffer {
    private static final Logger logger = LoggerFactory.getLogger(QueryBuffer.class);
    private QueryParameters parameters;
    private Entry firstEntry;
    private final SortedSet<Entry> entries = new TreeSet<Entry>();
    private Data[] data;
    private final boolean useNaNs = Boolean.getBoolean("org.eclipse.scada.hd.server.storage.hds.useNaNs");
    private final boolean renderWhileLoading = Boolean.getBoolean("org.eclipse.scada.hd.server.storage.hds.renderWhileLoading");

    public QueryBuffer(QueryListener listener, Executor executor, Date fixedStartDate, Date fixedEndDate) {
        super(listener, executor, fixedStartDate, fixedEndDate);
    }

    @Override
    protected QueryDataBuffer.Data[] getData() {
        return this.data;
    }

    public synchronized void changeParameters(QueryParameters parameters) {
        this.parameters = parameters;
        this.notifyStateUpdate(QueryState.LOADING);
        this.notifyParameterUpdate(parameters, new HashSet<String>(Arrays.asList("AVG", "MIN", "MAX", "STDDEV")));
        this.entries.clear();
        this.firstEntry = null;
        this.data = new Data[parameters.getNumberOfEntries()];
        QueryBuffer.fillDataCells((QueryDataBuffer.Data[])this.data, parameters.getStartTimestamp(), parameters.getEndTimestamp(), new DataFactory(){

            @Override
            public QueryDataBuffer.Data create(Date start, Date end) {
                return new Data(start, end);
            }
        });
    }

    public QueryParameters getParameters() {
        return this.parameters;
    }

    public synchronized void insertData(double value, Date timestamp, boolean error, boolean manual) {
        this.insertData(new Entry(value, timestamp, error, manual));
    }

    public synchronized void insertData(Entry entry) {
        Date timestamp = entry.getTimestamp();
        logger.debug("Received new data: {}", (Object)entry);
        if (this.parameters == null) {
            throw new IllegalStateException("Received data before parameter update");
        }
        if (timestamp.before(new Date(this.parameters.getStartTimestamp()))) {
            if (this.firstEntry == null || this.firstEntry.getTimestamp().before(timestamp)) {
                logger.debug("Evaluating entry as first entry: {}", (Object)entry);
                if (!Double.isNaN(entry.getValue()) || this.useNaNs) {
                    logger.debug("Using entry as first entry");
                    this.firstEntry = entry;
                }
            }
        } else if (!timestamp.after(new Date(this.parameters.getEndTimestamp()))) {
            logger.debug("Adding entry: {}", (Object)entry);
            this.entries.add(entry);
            int i = this.getDataIndex(timestamp);
            logger.debug("Inserting into cell: {}", (Object)i);
            if (i >= 0 && i < this.parameters.getNumberOfEntries()) {
                this.data[i].add(entry);
                if (this.renderWhileLoading && this.state == QueryState.LOADING) {
                    this.render(i, i + 1);
                }
            }
        }
    }

    private void render(int startIndex) {
        this.render(startIndex, Integer.MAX_VALUE);
    }

    private void render(int startIndex, int endIndex) {
        endIndex = Math.min(endIndex, this.parameters.getNumberOfEntries());
        Entry currentEntry = this.findPreviousEntry(startIndex);
        double max = Double.NaN;
        double min = Double.NaN;
        RunningAverage avg = new RunningAverage();
        RunningAverage quality = new RunningAverage();
        RunningAverage manual = new RunningAverage();
        if (currentEntry != null) {
            avg.next(currentEntry.getValue(), currentEntry.getTimestamp().getTime());
            quality.next(currentEntry.isError() ? 0.0 : 1.0, currentEntry.getTimestamp().getTime());
            manual.next(currentEntry.isManual() ? 1.0 : 0.0, currentEntry.getTimestamp().getTime());
            if (!Double.isNaN(currentEntry.getValue())) {
                min = max = currentEntry.getValue();
            }
        }
        int i = startIndex;
        while (i < endIndex) {
            avg.step(this.data[i].getStart().getTime());
            quality.step(this.data[i].getStart().getTime());
            manual.step(this.data[i].getStart().getTime());
            for (Entry entry : this.data[i].getEntries()) {
                quality.next(entry.isError() ? 0.0 : 1.0, entry.getTimestamp().getTime());
                manual.next(entry.isManual() ? 1.0 : 0.0, entry.getTimestamp().getTime());
                if (Double.isNaN(entry.getValue()) && !this.useNaNs) continue;
                avg.next(entry.getValue(), entry.getTimestamp().getTime());
                if (Double.isNaN(max) || Double.compare(entry.getValue(), max) > 0) {
                    max = entry.getValue();
                }
                if (Double.isNaN(min) || Double.compare(entry.getValue(), min) < 0) {
                    min = entry.getValue();
                }
                currentEntry = entry;
            }
            this.data[i].setAverage(avg.getAverage(this.data[i].getEnd().getTime()));
            this.data[i].setStdDev(avg.getDeviation(this.data[i].getEnd().getTime()));
            this.data[i].setQuality(quality.getAverage(this.data[i].getEnd().getTime()));
            this.data[i].setManual(manual.getAverage(this.data[i].getEnd().getTime()));
            this.data[i].setMin(min);
            this.data[i].setMax(max);
            if (currentEntry != null) {
                min = max = currentEntry.getValue();
            }
            ++i;
        }
        this.notifyData(startIndex, endIndex);
    }

    protected Entry findPreviousEntry(int i) {
        if (i <= 0) {
            return this.firstEntry;
        }
        if (this.data[i - 1].getEntries().isEmpty()) {
            return this.findPreviousEntry(i - 1);
        }
        return this.data[i - 1].getEntries().last();
    }

    protected Entry findNextEntry(int i) {
        if (i + 1 >= this.parameters.getNumberOfEntries()) {
            return null;
        }
        if (this.data[i + 1].getEntries().isEmpty()) {
            return this.findNextEntry(i + 1);
        }
        return this.data[i + 1].getEntries().first();
    }

    private int getDataIndex(Date timestamp) {
        if (timestamp.before(new Date(this.parameters.getStartTimestamp()))) {
            return -1;
        }
        double period = this.getPeriod();
        long offset = timestamp.getTime() - this.parameters.getStartTimestamp();
        return (int)((double)offset / period);
    }

    private double getPeriod() {
        return (double)(this.parameters.getEndTimestamp() - this.parameters.getStartTimestamp()) / (double)this.parameters.getNumberOfEntries();
    }

    public synchronized void complete() {
        this.render(0);
        this.notifyStateUpdate(QueryState.COMPLETE);
    }

    public synchronized void close() {
        this.notifyStateUpdate(QueryState.DISCONNECTED);
    }

    protected static class Data
    extends QueryDataBuffer.Data {
        private final TreeSet<Entry> entries = new TreeSet();
        private long entryCount;

        public Data(Date start, Date end) {
            super(start, end);
        }

        public void add(Entry entry) {
            if (!entry.getTimestamp().before(this.start) && entry.getTimestamp().before(this.end)) {
                this.entries.add(entry);
                if (!Double.isNaN(entry.value)) {
                    ++this.entryCount;
                }
            }
        }

        @Override
        public long getEntryCount() {
            return this.entryCount;
        }

        public SortedSet<Entry> getEntries() {
            return this.entries;
        }
    }

    static class Entry
    implements Comparable<Entry> {
        private final double value;
        private final Date timestamp;
        private final boolean error;
        private final boolean manual;

        public Entry(double value, Date timestamp, boolean error, boolean manual) {
            this.value = value;
            this.timestamp = timestamp;
            this.error = error;
            this.manual = manual;
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + (this.timestamp == null ? 0 : this.timestamp.hashCode());
            return result;
        }

        public Date getTimestamp() {
            return this.timestamp;
        }

        public double getValue() {
            return this.value;
        }

        public boolean isError() {
            return this.error;
        }

        public boolean isManual() {
            return this.manual;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Entry other = (Entry)obj;
            return !(this.timestamp == null ? other.timestamp != null : !this.timestamp.equals(other.timestamp));
        }

        @Override
        public int compareTo(Entry o) {
            return this.timestamp.compareTo(o.timestamp);
        }

        public String toString() {
            return String.format("[timestamp: %tc, value: %s, error: %s, manual: %s]", this.timestamp, this.value, this.error, this.manual);
        }
    }
}

