/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.ae.server.handler.mail;

import javax.mail.Address;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.NoSuchProviderException;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.MimeMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MailSender {
    private static final Logger logger = LoggerFactory.getLogger(MailSender.class);
    private final Session session;
    private final Address from;
    private final Address[] to;

    public MailSender(Session session, Address from, Address[] to, String password) throws NoSuchProviderException {
        this.session = session;
        this.from = from;
        this.to = to;
    }

    public void dispose() {
    }

    public void send(String subject, String text) throws MessagingException {
        MimeMessage message = new MimeMessage(this.session);
        if (this.from != null) {
            message.setFrom(this.from);
        } else {
            message.setFrom();
        }
        message.setHeader("Return-Path", "<>");
        message.setRecipients(Message.RecipientType.TO, this.to);
        message.setSubject(subject);
        message.setText(text);
        message.saveChanges();
        Transport transport = this.session.getTransport();
        logger.debug("Connecting transport...");
        transport.connect();
        logger.debug("Connecting transport... done!");
        try {
            logger.debug("Sending message...");
            transport.sendMessage((Message)message, message.getAllRecipients());
            logger.debug("Sending message... done!");
        }
        finally {
            logger.debug("Closing transport...");
            try {
                transport.close();
                logger.debug("Closing transport... done!");
            }
            catch (Exception e) {
                logger.info("Failed to close transport", (Throwable)e);
            }
        }
    }
}

