/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.ae.server.syslog;

import java.util.Map;
import org.eclipse.scada.ca.ConfigurationDataHelper;

public class ReceiverConfiguration {
    private final int port;
    private final String host;

    public ReceiverConfiguration(String host, int port) {
        this.host = host;
        this.port = port;
    }

    public int getPort() {
        return this.port;
    }

    public String getHost() {
        return this.host;
    }

    public static ReceiverConfiguration parse(String configurationId, Map<String, String> parameters) {
        ConfigurationDataHelper cfg = new ConfigurationDataHelper(parameters);
        String host = cfg.getString("host", null);
        int port = cfg.getIntegerChecked("port", "'port' is required");
        if (port <= 0 || port > 65536) {
            throw new IllegalArgumentException(String.format("Invalid port number: %s", port));
        }
        return new ReceiverConfiguration(host, port);
    }
}

