/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.ae.slave.inject;

import com.google.common.collect.Interner;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.List;
import java.util.Properties;
import org.eclipse.scada.ae.Event;
import org.eclipse.scada.ae.server.storage.jdbc.AbstractJdbcStorageDao;
import org.eclipse.scada.ae.slave.inject.Activator;
import org.eclipse.scada.utils.osgi.BundleObjectInputStream;
import org.eclipse.scada.utils.osgi.jdbc.data.RowMapper;
import org.eclipse.scada.utils.osgi.jdbc.data.SingleColumnRowMapper;
import org.eclipse.scada.utils.osgi.jdbc.task.CommonConnectionTask;
import org.eclipse.scada.utils.osgi.jdbc.task.ConnectionContext;
import org.eclipse.scada.utils.osgi.jdbc.task.ConnectionTask;
import org.eclipse.scada.utils.osgi.jdbc.task.RowCallback;
import org.osgi.service.jdbc.DataSourceFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JdbcStorageDao
extends AbstractJdbcStorageDao {
    private final boolean deleteFailed = Boolean.getBoolean("org.eclipse.scada.ae.slave.inject.deleteFailed");
    private static final Logger logger = LoggerFactory.getLogger(JdbcStorageDao.class);

    public JdbcStorageDao(DataSourceFactory dataSourceFactory, Properties properties, boolean usePool, Long loginTimeout, Interner<String> stringInterner) throws SQLException {
        super(dataSourceFactory, properties, usePool, loginTimeout, stringInterner);
    }

    private String getReplicationSelectSql() {
        return System.getProperty("org.eclipse.scada.ae.slave.inject.selectSql", String.format("SELECT ID, ENTRY_TIMESTAMP, NODE_ID, DATA FROM %sES_AE_REP", this.getReplicationSchema()));
    }

    private String getReplicationDeleteSql() {
        return System.getProperty("org.eclipse.scada.ae.slave.inject.deleteSql", String.format("DELETE FROM %sES_AE_REP where ID=?", this.getReplicationSchema()));
    }

    private String getEntryExistsSql() {
        return System.getProperty("org.eclipse.scada.ae.slave.inject.existsSql", String.format("SELECT COUNT(*) FROM %sES_AE_EVENTS WHERE ID=?", this.getSchema()));
    }

    private String getReplicationSchema() {
        return System.getProperty("org.eclipse.scada.ae.slave.inject.replicationSchema", "");
    }

    protected int runOnce() {
        return (Integer)this.accessor.doWithConnection((ConnectionTask)new CommonConnectionTask<Integer>(){

            protected Integer performTask(ConnectionContext connectionContext) throws Exception {
                connectionContext.setAutoCommit(false);
                int result = JdbcStorageDao.this.processOnce(connectionContext);
                connectionContext.commit();
                return result;
            }
        });
    }

    protected int processOnce(ConnectionContext connectionContext) throws SQLException {
        String selectSql = this.getReplicationSelectSql();
        RowHandler rowHandler = new RowHandler(connectionContext);
        connectionContext.query((RowCallback)rowHandler, selectSql, new Object[0]);
        return rowHandler.getCount();
    }

    protected void processRow(ConnectionContext connectionContext, ResultSet resultSet) throws SQLException {
        block3: {
            String id = resultSet.getString(1);
            logger.debug("Processing event {}", (Object)id);
            if (this.entryExists(connectionContext, id)) {
                logger.debug("Entry exists ... only delete");
                this.deleteReplicationEntry(connectionContext, id);
                return;
            }
            Timestamp entryTimestamp = resultSet.getTimestamp(2);
            String nodeId = resultSet.getString(3);
            byte[] data = resultSet.getBytes(4);
            logger.debug("Injecting event {} from node {}, timeDiff: {} ms, dataSize: {}", new Object[]{id, nodeId, System.currentTimeMillis() - entryTimestamp.getTime(), data.length});
            try {
                logger.debug("Storing event");
                this.storeEvent(this.deserializeEvent(data));
                this.deleteReplicationEntry(connectionContext, id);
            }
            catch (Exception e) {
                logger.warn("Failed to decode and store event", (Throwable)e);
                if (!this.deleteFailed) break block3;
                this.deleteReplicationEntry(connectionContext, id);
            }
        }
    }

    private Event deserializeEvent(byte[] data) throws IOException, ClassNotFoundException {
        logger.debug("Deserialize event");
        try (BundleObjectInputStream stream = new BundleObjectInputStream((InputStream)new ByteArrayInputStream(data), Activator.getContext().getBundle());){
            Object o = stream.readObject();
            if (o instanceof Event) {
                Event event = (Event)o;
                return event;
            }
            if (o == null) {
                logger.warn("Found null event");
                return null;
            }
            logger.warn("Expected event type {} but found {}. Discarding...", Event.class, o.getClass());
            return null;
        }
    }

    private void deleteReplicationEntry(ConnectionContext connectionContext, String id) throws SQLException {
        connectionContext.update(this.getReplicationDeleteSql(), new Object[]{id});
    }

    private boolean entryExists(ConnectionContext connectionContext, String id) throws SQLException {
        logger.debug("Checking if entry already exists");
        List result = connectionContext.query((RowMapper)new SingleColumnRowMapper(Number.class), this.getEntryExistsSql(), new Object[]{id});
        if (result.isEmpty()) {
            return false;
        }
        return ((Number)result.get(0)).intValue() > 0;
    }

    public class RowHandler
    implements RowCallback {
        private final ConnectionContext connectionContext;
        private int count;

        public RowHandler(ConnectionContext connectionContext) {
            this.connectionContext = connectionContext;
        }

        public void processRow(ResultSet resultSet) throws SQLException {
            ++this.count;
            JdbcStorageDao.this.processRow(this.connectionContext, resultSet);
        }

        public int getCount() {
            return this.count;
        }
    }
}

