/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.da.datasource.base;

import java.util.Calendar;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.eclipse.scada.core.Variant;
import org.eclipse.scada.da.client.DataItemValue;
import org.eclipse.scada.da.datasource.DataSource;
import org.eclipse.scada.da.datasource.DataSourceListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractDataSource
implements DataSource {
    private static final Logger logger = LoggerFactory.getLogger(AbstractDataSource.class);
    private DataItemValue value = DataItemValue.DISCONNECTED;
    private final Set<DataSourceListener> listeners = new HashSet<DataSourceListener>(1);
    private Variant lastValue = Variant.NULL;
    private Calendar lastTimestamp = null;
    private final Lock lock = new ReentrantLock();

    protected abstract Executor getExecutor();

    @Override
    public void addListener(final DataSourceListener listener) {
        try {
            this.lock.lock();
            if (this.listeners.add(listener)) {
                final DataItemValue value = this.value;
                this.getExecutor().execute(new Runnable(){

                    @Override
                    public void run() {
                        listener.stateChanged(value);
                    }
                });
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void removeListener(DataSourceListener listener) {
        try {
            this.lock.lock();
            this.listeners.remove(listener);
        }
        finally {
            this.lock.unlock();
        }
    }

    protected void updateData(DataItemValue value) {
        logger.debug("Update data: {} -> {}", new Object[]{value, value == null ? "" : value.getAttributes()});
        try {
            this.lock.lock();
            if (this.value != null && this.value.equals((Object)value)) {
                logger.debug("No data change. Discarding");
                return;
            }
            this.lastValue = (value = this.applyAutoTimestamp(value)) == null ? null : value.getValue();
            this.value = value;
            final DataItemValue finalValue = value;
            for (final DataSourceListener listener : this.listeners) {
                this.getExecutor().execute(new Runnable(){

                    @Override
                    public void run() {
                        listener.stateChanged(finalValue);
                    }
                });
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    private DataItemValue applyAutoTimestamp(DataItemValue value) {
        if (value != null && value.getTimestamp() == null) {
            try {
                if (!this.lastValue.equals((Object)value.getValue())) {
                    this.lastTimestamp = Calendar.getInstance();
                }
            }
            catch (Exception e) {
                logger.info("Failed to update timestamp", (Throwable)e);
            }
            DataItemValue.Builder builder = new DataItemValue.Builder(value);
            builder.setTimestamp(this.lastTimestamp);
            value = builder.build();
        }
        return value;
    }
}

