/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.da.server.exec.command;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.scada.core.Variant;
import org.eclipse.scada.core.VariantEditor;
import org.eclipse.scada.da.server.browser.common.FolderCommon;
import org.eclipse.scada.da.server.common.AttributeMode;
import org.eclipse.scada.da.server.common.DataItem;
import org.eclipse.scada.da.server.common.chain.DataItemInputChained;
import org.eclipse.scada.da.server.common.item.factory.FolderItemFactory;
import org.eclipse.scada.da.server.exec.Hive;
import org.eclipse.scada.da.server.exec.command.AbstractContinuousCommand;
import org.eclipse.scada.da.server.exec.command.ProcessConfiguration;
import org.eclipse.scada.da.server.exec.splitter.SplitSplitter;

public class HiveProcessCommand
extends AbstractContinuousCommand {
    private final VariantEditor variantEditor = new VariantEditor();
    private FolderItemFactory processItemFactory;
    private final Map<String, DataItemInputChained> items = new HashMap<String, DataItemInputChained>();

    public HiveProcessCommand(String id, ProcessConfiguration processConfiguration, int restartDelay, int maxInputBuffer) {
        super(id, processConfiguration, restartDelay, maxInputBuffer, new SplitSplitter(System.getProperty("line.separator")));
    }

    @Override
    public void start(Hive hive, FolderCommon parentFolder) {
        super.start(hive, parentFolder);
        this.processItemFactory = this.itemFactory.createSubFolderFactory("values");
    }

    @Override
    public void stop() {
        this.disposeItems();
        super.stop();
    }

    @Override
    protected void handleStdLine(String line) {
        String itemId;
        DataItemInputChained item;
        String[] toks = this.split(line);
        if (toks.length < 1) {
            return;
        }
        if ("DATA-CHANGED".equals(toks[0])) {
            String itemId2 = toks[1];
            String value = toks[2];
            DataItemInputChained item2 = this.items.get(itemId2);
            if (item2 == null) {
                return;
            }
            Variant variant = null;
            this.variantEditor.setAsText(value);
            variant = (Variant)this.variantEditor.getValue();
            HashMap<String, Variant> attributes = new HashMap<String, Variant>();
            int i = 3;
            while (i < toks.length) {
                String attribute = toks[i];
                String[] attr = attribute.split("=", 2);
                if (attr.length > 1) {
                    this.variantEditor.setAsText(attr[1]);
                    attributes.put(attr[0], (Variant)this.variantEditor.getValue());
                } else {
                    attributes.put(attr[0], null);
                }
                ++i;
            }
            item2.updateData(variant, attributes, AttributeMode.SET);
        } else if ("REGISTER".equals(toks[0])) {
            String itemId3 = toks[1];
            if (!this.items.containsKey(itemId3)) {
                DataItemInputChained item3 = this.processItemFactory.createInput(itemId3, null);
                this.items.put(itemId3, item3);
            }
        } else if ("UNREGISTER".equals(toks[0]) && (item = this.items.get(itemId = toks[1])) != null) {
            this.processItemFactory.disposeItem((DataItem)item);
        }
    }

    private String[] split(String line) {
        return line.split("/");
    }

    @Override
    protected void processFailed(Throwable e) {
        this.processItemFactory.disposeAllItems();
        this.items.clear();
        super.processFailed(e);
    }

    private void disposeItems() {
        if (this.processItemFactory != null) {
            this.processItemFactory.dispose();
            this.processItemFactory = null;
        }
        this.items.clear();
    }
}

