/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.da.server.io.common;

import java.net.SocketAddress;
import org.apache.mina.core.filterchain.IoFilter;
import org.apache.mina.core.future.ConnectFuture;
import org.apache.mina.core.future.IoFutureListener;
import org.apache.mina.core.service.IoHandler;
import org.apache.mina.core.session.IdleStatus;
import org.apache.mina.core.session.IoSession;
import org.apache.mina.filter.logging.LoggingFilter;
import org.apache.mina.transport.socket.SocketConnector;
import org.apache.mina.transport.socket.nio.NioSocketConnector;
import org.eclipse.scada.da.server.io.common.BaseDevice;
import org.eclipse.scada.da.server.io.common.ConnectionListener;
import org.eclipse.scada.da.server.io.common.GenericBaseDevice;
import org.eclipse.scada.da.server.io.common.NotConnectedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class StreamBaseDevice
extends GenericBaseDevice
implements BaseDevice {
    private static final Logger logger = LoggerFactory.getLogger(StreamBaseDevice.class);
    public static final int CONNECT_TIMEOUT = Integer.getInteger("org.eclipse.scada.da.server.io.common.connectTimeout", 5000);
    private SocketConnector connector;
    private final SocketAddress address;
    protected IoSession session;
    private long timeoutTime = Integer.getInteger("org.eclipse.scada.da.server.io.common.defaultTimeout", 10000).intValue();

    public StreamBaseDevice(SocketAddress address) {
        this.address = address;
    }

    protected abstract void setupConnector(SocketConnector var1);

    @Override
    public boolean isConnected() {
        return this.session != null;
    }

    @Override
    public synchronized void connect() {
        if (this.isConnected()) {
            logger.info("Already connected");
            return;
        }
        if (this.connector == null) {
            this.connector = new NioSocketConnector();
            this.connector.setHandler((IoHandler)this);
            if (Boolean.getBoolean("org.eclipse.scada.da.server.io.common.trace")) {
                this.connector.getFilterChain().addLast("logger", (IoFilter)new LoggingFilter());
            }
            this.setupConnector(this.connector);
        }
        ConnectFuture cu = this.connector.connect(this.address);
        cu.addListener((IoFutureListener)new IoFutureListener<ConnectFuture>(){

            public void operationComplete(ConnectFuture future) {
                try {
                    future.getSession();
                }
                catch (Throwable e) {
                    StreamBaseDevice.this.fireConnectionFailed(e);
                }
            }
        });
    }

    @Override
    public synchronized void dispose() {
        if (this.connector != null) {
            this.connector.dispose();
            this.connector = null;
        }
    }

    public void sessionCreated(IoSession session) throws Exception {
        logger.debug("Session created");
        session.getConfig().setIdleTime(IdleStatus.BOTH_IDLE, (int)(this.timeoutTime / 1000L));
    }

    protected void setTimeout(long timeout) {
        logger.info("Settings timeout: {}", (Object)timeout);
        this.timeoutTime = timeout;
        if (this.session != null) {
            this.session.getConfig().setIdleTime(IdleStatus.BOTH_IDLE, (int)(this.timeoutTime / 1000L));
        }
    }

    public void sessionOpened(IoSession session) throws Exception {
        logger.debug("Session opened");
        this.session = session;
        this.fireConnected();
    }

    public void sessionIdle(IoSession session, IdleStatus status) throws Exception {
        logger.debug("Close session due to idle time");
        session.close(true);
    }

    public void sessionClosed(IoSession session) throws Exception {
        logger.debug("Session closed");
        this.session = null;
        for (ConnectionListener listener : this.connectionListeners) {
            listener.closed(null);
        }
    }

    protected void writeMessage(Object message) throws NotConnectedException {
        IoSession session = this.session;
        if (session == null) {
            throw new NotConnectedException();
        }
        session.write(message);
    }

    protected void writeMessageIgnore(Object message) {
        IoSession session = this.session;
        if (session != null) {
            session.write(message);
        }
    }
}

