/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.da.component.script;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.eclipse.scada.core.Variant;
import org.eclipse.scada.core.connection.provider.ConnectionIdTracker;
import org.eclipse.scada.core.server.OperationParameters;
import org.eclipse.scada.core.server.OperationParametersHelper;
import org.eclipse.scada.da.component.script.ItemWrapper;
import org.eclipse.scada.da.component.script.ScriptContext;
import org.eclipse.scada.da.connection.provider.ConnectionService;
import org.eclipse.scada.da.server.common.DataItem;
import org.eclipse.scada.da.server.common.chain.DataItemInputChained;
import org.eclipse.scada.da.server.common.chain.WriteHandler;
import org.eclipse.scada.da.server.common.chain.WriteHandlerItem;
import org.eclipse.scada.utils.osgi.pool.ObjectPoolImpl;
import org.osgi.framework.BundleContext;

public class ScriptContextImpl
implements ScriptContext {
    private final BundleContext context;
    private final Map<String, String> parameters;
    private final Executor executor;
    private final Map<String, ScriptContext.Item> items = new HashMap<String, ScriptContext.Item>();
    private final Lock itemsLock = new ReentrantLock();
    private final ObjectPoolImpl<DataItem> objectPool;

    public ScriptContextImpl(Executor executor, ObjectPoolImpl<DataItem> objectPool, String id, BundleContext context, Map<String, String> parameters) {
        this.executor = executor;
        this.context = context;
        this.objectPool = objectPool;
        this.parameters = Collections.unmodifiableMap(parameters);
    }

    @Override
    public ScriptContext.Item registerItem(String itemId, Map<String, Variant> attributes, WriteHandler writeHandler) {
        if (writeHandler != null) {
            return this.registerItem(new ItemWrapper(this.objectPool, (DataItemInputChained)new WriteHandlerItem(itemId, writeHandler, this.executor), attributes));
        }
        return this.registerItem(new ItemWrapper(this.objectPool, new DataItemInputChained(itemId, this.executor), attributes));
    }

    private ScriptContext.Item registerItem(ScriptContext.Item item) {
        this.itemsLock.lock();
        try {
            ScriptContext.Item oldItem = this.items.remove(item.getItemId());
            if (oldItem != null) {
                oldItem.dispose();
            }
            this.items.put(item.getItemId(), item);
            ScriptContext.Item item2 = item;
            return item2;
        }
        finally {
            this.itemsLock.unlock();
        }
    }

    @Override
    public void unregisterItem(String itemId) {
        ScriptContext.Item item;
        this.itemsLock.lock();
        try {
            item = this.items.remove(itemId);
        }
        finally {
            this.itemsLock.unlock();
        }
        if (item != null) {
            item.dispose();
        }
    }

    @Override
    public void unregisterItem(ScriptContext.Item item) {
        this.unregisterItem(item.getItemId());
    }

    @Override
    public void writeDataItem(String connectionId, String itemId, Variant value, OperationParameters operationParameters) throws Exception {
        tracker.open();
        try (ConnectionIdTracker tracker = new ConnectionIdTracker(this.context, connectionId, null, ConnectionService.class);){
            ConnectionService service = (ConnectionService)tracker.waitForService(0L);
            if (service != null) {
                service.getConnection().startWrite(itemId, value, OperationParametersHelper.toData((OperationParameters)operationParameters), null);
            }
        }
    }

    @Override
    public void dispose() {
        this.itemsLock.lock();
        try {
            for (ScriptContext.Item item : this.items.values()) {
                item.dispose();
            }
            this.items.clear();
        }
        finally {
            this.itemsLock.unlock();
        }
    }

    @Override
    public Map<String, String> getParameters() {
        return this.parameters;
    }
}

