/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.core.server.ngp;

import java.net.SocketAddress;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.net.ssl.SSLSession;
import org.apache.mina.core.session.IoSession;
import org.apache.mina.filter.ssl.SslFilter;
import org.eclipse.scada.core.server.common.stats.ManagedConnection;
import org.eclipse.scada.protocol.common.StatisticsFilter;
import org.eclipse.scada.protocol.ngp.common.mc.MessageChannelFilter;
import org.eclipse.scada.utils.stats.StatisticEntry;
import org.eclipse.scada.utils.stats.StatisticsImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ServerConnection {
    private static final Logger logger = LoggerFactory.getLogger(ServerConnection.class);
    private static final Object STATS_MESSAGES_SENT = new Object();
    private static final Object STATS_MESSAGES_RECEIVED = new Object();
    private final IoSession session;
    protected final StatisticsImpl statistics;
    private ManagedConnection mxBean;
    private final Object writeLock = new Object();
    private final AtomicBoolean closing = new AtomicBoolean(false);

    public ServerConnection(final IoSession session) {
        logger.info("Creating new server connection: {}", (Object)session);
        this.statistics = new StatisticsImpl();
        this.session = session;
        this.mxBean = ManagedConnection.register((ManagedConnection)new ManagedConnection(){

            protected Collection<StatisticEntry> getEntries() {
                return ServerConnection.this.statistics.getEntries();
            }

            public void close() {
                ServerConnection.this.session.close(false);
            }

            public Map<String, String> getTransportProperties() {
                MessageChannelFilter mcf = (MessageChannelFilter)session.getFilterChain().get(MessageChannelFilter.class);
                if (mcf != null) {
                    return mcf.getAcceptedProperties();
                }
                return null;
            }
        }, (SocketAddress)session.getRemoteAddress(), (String)"org.eclipse.scada.core.server.ngp");
        this.statistics.setLabel(STATS_MESSAGES_SENT, "Messages sent");
        this.statistics.setLabel(STATS_MESSAGES_RECEIVED, "Messages received");
        session.setAttribute((Object)StatisticsFilter.STATS_KEY, (Object)this.statistics);
    }

    public void dispose() {
        logger.info("Disposing server connection: {}", (Object)this.session);
        if (this.mxBean != null) {
            this.mxBean.dispose();
            this.mxBean = null;
        }
        this.requestClose(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sendMessage(Object message) {
        logger.trace("Sending message: {}", message);
        this.statistics.changeCurrentValue(STATS_MESSAGES_SENT, 1.0);
        Object object = this.writeLock;
        synchronized (object) {
            this.session.write(message);
        }
    }

    public void requestClose(boolean immediately) {
        if (this.closing.compareAndSet(false, true)) {
            this.session.close(immediately);
        }
    }

    public abstract void messageReceived(Object var1) throws Exception;

    public void handleMessageReceived(Object message) throws Exception {
        logger.trace("Message received: {}", message);
        this.statistics.changeCurrentValue(STATS_MESSAGES_RECEIVED, 1.0);
        this.messageReceived(message);
    }

    public SSLSession getSslSession() {
        IoSession session = this.session;
        if (session == null) {
            return null;
        }
        Object sslSession = session.getAttribute((Object)SslFilter.SSL_SESSION);
        if (sslSession instanceof SSLSession) {
            return (SSLSession)sslSession;
        }
        return null;
    }
}

