/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.ae.monitor.datasource.common.level;

import com.google.common.collect.Interner;
import java.util.Map;
import java.util.concurrent.Executor;
import org.eclipse.scada.ae.data.Severity;
import org.eclipse.scada.ae.event.EventProcessor;
import org.eclipse.scada.ae.monitor.common.level.LevelHelper;
import org.eclipse.scada.ae.monitor.datasource.AbstractMasterItemMonitor;
import org.eclipse.scada.ae.monitor.datasource.AbstractNumericMonitor;
import org.eclipse.scada.ae.monitor.datasource.Helper;
import org.eclipse.scada.ae.monitor.datasource.common.level.Configuration;
import org.eclipse.scada.ca.ConfigurationDataHelper;
import org.eclipse.scada.core.Variant;
import org.eclipse.scada.da.client.DataItemValue;
import org.eclipse.scada.da.core.WriteAttributeResult;
import org.eclipse.scada.da.core.WriteAttributeResults;
import org.eclipse.scada.da.master.MasterItem;
import org.eclipse.scada.sec.UserInformation;
import org.eclipse.scada.utils.osgi.pool.ObjectPoolTracker;
import org.osgi.framework.BundleContext;

public class LevelMonitor
extends AbstractNumericMonitor {
    private final String firstPrefix;
    private Configuration configuration;

    public LevelMonitor(BundleContext context, Executor executor, Interner<String> stringInterner, ObjectPoolTracker<MasterItem> poolTracker, EventProcessor eventProcessor, String id, String prefix, String defaultMonitorType) {
        super(context, executor, stringInterner, poolTracker, eventProcessor, id, "org.eclipse.scada.ae.monitor.level", prefix, defaultMonitorType);
        this.firstPrefix = prefix;
    }

    protected int getDefaultHandlerPriority() {
        return 500;
    }

    protected void performNumericUpdate(DataItemValue.Builder builder, Number value) {
        if (this.configuration == null || this.configuration.preset == null) {
            this.setOk(builder.getValue(), Helper.getTimestamp((DataItemValue.Builder)builder));
            return;
        }
        Variant originalValue = builder.getValue();
        Variant newValue = Variant.valueOf((Object)value);
        boolean failure = LevelHelper.isFailure((double)value.doubleValue(), (double)this.configuration.preset, (boolean)this.configuration.lowerOk, (boolean)this.configuration.includedOk);
        if (failure) {
            Variant cappedValue;
            if (this.configuration.cap && !(cappedValue = this.capValue(this.configuration.preset, value)).equals((Object)newValue)) {
                builder.setValue(cappedValue);
                builder.setAttribute(String.valueOf(this.firstPrefix) + ".value.original", newValue);
            }
            this.setFailure(originalValue, Helper.getTimestamp((DataItemValue.Builder)builder), this.configuration.severity, this.configuration.requireAck);
        } else {
            this.setOk(originalValue, Helper.getTimestamp((DataItemValue.Builder)builder));
        }
    }

    private Variant capValue(double preset, Number value) {
        if (this.configuration.lowerOk) {
            if (value instanceof Long) {
                return Variant.valueOf((long)Math.min((long)preset, value.longValue()));
            }
            if (value instanceof Integer) {
                return Variant.valueOf((int)Math.min((int)preset, value.intValue()));
            }
            return Variant.valueOf((double)Math.min(preset, value.doubleValue()));
        }
        if (value instanceof Long) {
            return Variant.valueOf((long)Math.max((long)preset, value.longValue()));
        }
        if (value instanceof Integer) {
            return Variant.valueOf((int)Math.max((int)preset, value.intValue()));
        }
        return Variant.valueOf((double)Math.max(preset, value.doubleValue()));
    }

    public synchronized void update(UserInformation userInformation, Map<String, String> properties) throws Exception {
        super.update(userInformation, properties);
        ConfigurationDataHelper cfg = new ConfigurationDataHelper(properties);
        Configuration c = new Configuration(this.configuration, (AbstractMasterItemMonitor)this);
        c.setPreset(userInformation, cfg.getDouble("preset"));
        c.setLowerOk(userInformation, cfg.getBooleanChecked("lowerOk", "'lowerOk' is required"));
        c.setIncludedOk(userInformation, cfg.getBoolean("includedOk", true));
        c.setSecondPrefix(userInformation, cfg.getString("prefix", null));
        c.setCap(userInformation, cfg.getBoolean("cap", false));
        c.setSeverity(userInformation, (Severity)cfg.getEnum("severity", Severity.class, (Enum)Severity.ALARM));
        c.setRequireAck(userInformation, cfg.getBoolean("requireAck", false));
        this.configuration = c;
        c.sendEvents();
        if (this.configuration.secondPrefix != null) {
            this.setPrefix(String.valueOf(this.firstPrefix) + "." + this.configuration.secondPrefix);
        } else {
            this.setPrefix(this.firstPrefix);
        }
        this.reprocess();
    }

    protected void injectAttributes(DataItemValue.Builder builder) {
        super.injectAttributes(builder);
        if (this.configuration != null) {
            builder.setAttribute(this.intern(String.valueOf(this.getPrefix()) + ".preset"), Variant.valueOf((Object)this.configuration.preset));
        }
    }

    protected void handleConfigUpdate(Map<String, String> configUpdate, Map<String, Variant> attributes, WriteAttributeResults result) {
        super.handleConfigUpdate(configUpdate, attributes, result);
        Variant preset = attributes.get(String.valueOf(this.getPrefix()) + ".preset");
        if (preset != null) {
            configUpdate.put("preset", "" + preset.asDouble(Double.valueOf(0.0)));
            result.put((Object)this.intern(String.valueOf(this.getPrefix()) + ".preset"), (Object)WriteAttributeResult.OK);
        }
    }
}

