/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.da.server.proxy.connection;

import java.util.HashMap;
import org.eclipse.scada.core.InvalidOperationException;
import org.eclipse.scada.core.NotConvertableException;
import org.eclipse.scada.core.NullValueException;
import org.eclipse.scada.core.Variant;
import org.eclipse.scada.core.server.OperationParameters;
import org.eclipse.scada.da.client.Connection;
import org.eclipse.scada.da.server.browser.common.Folder;
import org.eclipse.scada.da.server.browser.common.FolderCommon;
import org.eclipse.scada.da.server.common.AttributeMode;
import org.eclipse.scada.da.server.common.DataItem;
import org.eclipse.scada.da.server.common.DataItemCommand;
import org.eclipse.scada.da.server.common.chain.DataItemInputChained;
import org.eclipse.scada.da.server.common.chain.WriteHandler;
import org.eclipse.scada.da.server.common.chain.WriteHandlerItem;
import org.eclipse.scada.da.server.proxy.Hive;
import org.eclipse.scada.da.server.proxy.connection.NotifyConnectionErrorListener;
import org.eclipse.scada.da.server.proxy.connection.ProxyDataItemFactory;
import org.eclipse.scada.da.server.proxy.connection.ProxyGroup;
import org.eclipse.scada.da.server.proxy.connection.ProxySubConnection;
import org.eclipse.scada.da.server.proxy.item.ProxyDataItem;
import org.eclipse.scada.da.server.proxy.utils.ProxyPrefixName;
import org.eclipse.scada.da.server.proxy.utils.ProxySubConnectionId;
import org.eclipse.scada.utils.collection.MapBuilder;
import org.eclipse.scada.utils.lifecycle.LifecycleAware;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProxyConnection
implements LifecycleAware {
    private static final Logger logger = LoggerFactory.getLogger(ProxyConnection.class);
    public static final String ITEM_PREFIX = "proxy.connection";
    private final Hive hive;
    private final ProxyGroup group;
    private final FolderCommon connectionsFolder;
    private final String separator;
    private WriteHandlerItem activeConnectionItem;
    private DataItemInputChained switchStarted;
    private DataItemInputChained switchEnded;
    private DataItemInputChained switchInProgress;
    private DataItemInputChained switchDuration;
    private final FolderCommon connectionFolder;
    private DataItemCommand connectItem;
    private DataItemCommand disconnectItem;
    private final ProxyDataItemFactory factory;

    public ProxyConnection(Hive hive, ProxyPrefixName prefix, FolderCommon connectionsFolder) {
        this.hive = hive;
        this.connectionsFolder = connectionsFolder;
        this.group = new ProxyGroup(hive, prefix);
        this.separator = this.hive.getSeparator();
        this.connectionFolder = new FolderCommon();
        this.group.setConnectionFolder(this.connectionFolder);
        this.connectionsFolder.add(this.group.getPrefix().getName(), (Folder)this.connectionFolder, new HashMap());
        this.factory = new ProxyDataItemFactory(prefix, this, hive, this.separator);
    }

    protected DataItemInputChained createItem(String localId) {
        DataItemInputChained item = new DataItemInputChained(this.itemName(localId), this.hive.getOperationService());
        this.hive.registerItem((DataItem)item);
        this.connectionFolder.add(localId, (DataItem)item, new MapBuilder().getMap());
        return item;
    }

    private String itemName(String localId) {
        return String.valueOf(this.group.getPrefix().getName()) + this.separator + ITEM_PREFIX + this.separator + localId;
    }

    public void start() {
        this.switchStarted = this.createItem("switch.started");
        this.switchEnded = this.createItem("switch.ended");
        this.switchInProgress = this.createItem("switch.inprogress");
        this.switchDuration = this.createItem("switch.duration");
        this.activeConnectionItem = new WriteHandlerItem(this.itemName("active"), new WriteHandler(){

            public void handleWrite(Variant value, OperationParameters operationParameters) throws Exception {
                String newId = value.asString(null);
                ProxyConnection.this.switchTo(newId);
            }
        }, this.hive.getOperationService());
        this.hive.registerItem((DataItem)this.activeConnectionItem);
        HashMap<String, Variant> availableConnections = new HashMap<String, Variant>();
        for (ProxySubConnection subConnection : this.group.getSubConnections().values()) {
            availableConnections.put("available.connection." + subConnection.getId(), Variant.valueOf((Object)subConnection.getPrefix().getName()));
        }
        this.connectionFolder.add("active", (DataItem)this.activeConnectionItem, availableConnections);
        this.activeConnectionItem.updateData(Variant.valueOf((Object)this.group.getCurrentConnection().toString()), availableConnections, AttributeMode.SET);
        this.connectItem = new DataItemCommand(this.itemName("connect"), this.hive.getOperationService());
        this.connectItem.addListener(new DataItemCommand.Listener(){

            public void command(Variant value) throws Exception {
                ProxyConnection.this.group.connectCurrentConnection();
            }
        });
        this.hive.registerItem((DataItem)this.connectItem);
        this.connectionFolder.add("connect", (DataItem)this.connectItem, new MapBuilder().getMap());
        this.disconnectItem = new DataItemCommand(this.itemName("disconnect"), this.hive.getOperationService());
        this.disconnectItem.addListener(new DataItemCommand.Listener(){

            public void command(Variant value) throws Exception {
                ProxyConnection.this.group.connectCurrentConnection();
            }
        });
        this.hive.registerItem((DataItem)this.disconnectItem);
        this.connectionFolder.add("disconnect", (DataItem)this.disconnectItem, new MapBuilder().getMap());
        this.group.addConnectionStateListener(new NotifyConnectionErrorListener(this.group));
        this.group.start();
        this.hive.addItemFactory(this.factory);
    }

    protected void switchTo(String newId) {
        try {
            ProxySubConnection newSubConnection = this.group.getSubConnections().get(new ProxySubConnectionId(newId));
            if (newSubConnection != null) {
                this.switchTo(newSubConnection.getId());
            }
        }
        catch (Throwable e) {
            logger.error(String.format("Failed to switch to: %s", newId), e);
        }
    }

    protected void switchTo(ProxySubConnectionId id) {
        long start = System.currentTimeMillis();
        this.switchStarted.updateData(Variant.valueOf((long)start), null, AttributeMode.UPDATE);
        this.switchInProgress.updateData(Variant.TRUE, null, AttributeMode.UPDATE);
        try {
            this.group.switchTo(id);
            this.activeConnectionItem.updateData(Variant.valueOf((Object)id), null, null);
        }
        finally {
            this.switchInProgress.updateData(Variant.FALSE, null, AttributeMode.UPDATE);
            long end = System.currentTimeMillis();
            this.switchEnded.updateData(Variant.valueOf((long)end), null, AttributeMode.UPDATE);
            this.switchDuration.updateData(Variant.valueOf((long)(end - start)), null, AttributeMode.UPDATE);
        }
    }

    public ProxyDataItem realizeItem(String id) {
        return this.group.realizeItem(id);
    }

    public void stop() {
        this.hive.removeItemFactory(this.factory);
        this.group.stop();
    }

    public ProxyPrefixName getPrefix() {
        return this.group.getPrefix();
    }

    public void setWait(int wait) {
        this.group.setWait(wait);
    }

    public void addConnection(Connection connection, String id, ProxyPrefixName proxyPrefixName) throws InvalidOperationException, NullValueException, NotConvertableException {
        this.group.addConnection(connection, id, proxyPrefixName, this.connectionFolder);
    }
}

