/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.ae.slave.pull;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.eclipse.scada.ae.slave.pull.Activator;
import org.eclipse.scada.ae.slave.pull.Site;
import org.eclipse.scada.ca.ConfigurationDataHelper;
import org.eclipse.scada.ca.ConfigurationFactory;
import org.eclipse.scada.sec.UserInformation;
import org.eclipse.scada.utils.osgi.jdbc.DataSourceConnectionAccessor;
import org.eclipse.scada.utils.osgi.jdbc.DataSourceFactoryTracker;
import org.eclipse.scada.utils.osgi.jdbc.DataSourceHelper;
import org.eclipse.scada.utils.osgi.jdbc.data.RowMapper;
import org.eclipse.scada.utils.osgi.jdbc.data.SingleColumnRowMapper;
import org.eclipse.scada.utils.osgi.jdbc.task.CommonConnectionTask;
import org.eclipse.scada.utils.osgi.jdbc.task.ConnectionContext;
import org.eclipse.scada.utils.osgi.jdbc.task.ConnectionTask;
import org.eclipse.scada.utils.osgi.jdbc.task.RowCallback;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.service.jdbc.DataSourceFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PullManager
implements ConfigurationFactory {
    private static final String SPECIFIC_PREFIX = "org.eclipse.scada.ae.slave.pull";
    private static final Logger logger = LoggerFactory.getLogger(PullManager.class);
    public static final String FACTORY_ID = "org.eclipse.scada.ae.slave.pull";
    private final List<Site> sites = new ArrayList<Site>();
    private volatile boolean needRefresh;
    private final Thread thread;
    private volatile boolean running = true;
    private final long gracePeriod = 10000L;
    private Map<String, DataSourceFactoryTracker> dataSourceFactoryTrackers = new HashMap<String, DataSourceFactoryTracker>();
    private final DataSourceFactoryTracker tracker;

    public PullManager() throws InvalidSyntaxException {
        String driver = DataSourceHelper.getDriver((String)"org.eclipse.scada.ae.slave.pull", (String)"org.eclipse.scada.jdbc");
        this.tracker = new DataSourceFactoryTracker(Activator.getContext(), driver, null);
        if (driver == null) {
            logger.error("JDBC driver is not set");
            throw new IllegalStateException("JDBC driver name is not set");
        }
        this.tracker.open();
        this.thread = new Thread("org.eclipse.scada.ae.slave.pull.Worker"){

            @Override
            public void run() {
                PullManager.this.run();
            }
        };
        this.thread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void dispose() {
        var1_1 = this;
        synchronized (var1_1) {
            if (!this.running) {
                return;
            }
            this.running = false;
            this.notifyAll();
        }
        endWait = System.currentTimeMillis() + 10000L;
        PullManager.logger.debug("Waiting until {}", (Object)endWait);
        try {
            if (true) ** GOTO lbl24
            while (true) {
                delay = endWait - System.currentTimeMillis();
                PullManager.logger.debug("Waiting for {} ms", (Object)delay);
                try {
                    this.thread.join(delay);
                    return;
                }
                catch (InterruptedException e) {
                    PullManager.logger.warn("Got interrupted while waiting for thread shutdown", (Throwable)e);
lbl24:
                    // 2 sources

                    if (this.thread.isAlive()) {
                        if (endWait > System.currentTimeMillis()) continue;
                    }
                }
                break;
            }
        }
        finally {
            if (this.thread.isAlive()) {
                PullManager.logger.warn("Failed to stop thread after {} ms - now: {}", (Object)10000L, (Object)System.currentTimeMillis());
            }
            this.disposeTrackers();
            this.tracker.close();
        }
    }

    private void disposeTrackers() {
        for (DataSourceFactoryTracker tracker : this.dataSourceFactoryTrackers.values()) {
            tracker.close();
        }
        this.dataSourceFactoryTrackers.clear();
    }

    public void run() {
        try {
            while (this.running) {
                if (!this.running) {
                    logger.warn("Not running anymore. Exiting pull thread...");
                    return;
                }
                try {
                    this.runOnce();
                }
                catch (Exception e) {
                    logger.warn("Failed to process", (Throwable)e);
                }
                this.waitForNext();
            }
        }
        finally {
            this.disposeTrackers();
        }
    }

    private synchronized void waitForNext() {
        long start = this.nextStart();
        logger.debug("Next site due in {} ms", (Object)(start - System.currentTimeMillis()));
        while (start > System.currentTimeMillis()) {
            try {
                if (!this.running) {
                    return;
                }
                this.wait(start - System.currentTimeMillis());
                if (!this.needRefresh) continue;
                start = this.nextStart();
                logger.debug("Update - Next site due in {} ms", (Object)(start - System.currentTimeMillis()));
            }
            catch (InterruptedException e) {
                logger.warn("Failed to wait for next", (Throwable)e);
            }
        }
    }

    private long nextStart() {
        if (this.sites.isEmpty()) {
            return Long.MAX_VALUE;
        }
        Collections.sort(this.sites, new Comparator<Site>(){

            @Override
            public int compare(Site o1, Site o2) {
                return Long.valueOf(o1.nextStart()).compareTo(o2.nextStart());
            }
        });
        Site nextSite = this.sites.get(0);
        return nextSite.nextStart();
    }

    public void runOnce() throws SQLException {
        DataSourceFactory localFactory = (DataSourceFactory)this.tracker.getService();
        if (localFactory == null) {
            throw new IllegalStateException(String.format("Failed to get local data source factory - %s", this.tracker.getDriver()));
        }
        Properties properties = DataSourceHelper.getDataSourceProperties((String)"org.eclipse.scada.ae.slave.pull", (String)"org.eclipse.scada.jdbc");
        logger.debug("Opening database connection for local: {}", (Object)properties);
        DataSourceConnectionAccessor accessor = new DataSourceConnectionAccessor(localFactory, properties);
        try {
            accessor.doWithConnection((ConnectionTask)new CommonConnectionTask<Void>(){

                protected Void performTask(ConnectionContext connectionContext) throws Exception {
                    PullManager.this.processSites(connectionContext);
                    return null;
                }
            });
        }
        finally {
            accessor.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processSites(ConnectionContext localContext) {
        Site[] sites;
        boolean updateTrackers = false;
        PullManager pullManager = this;
        synchronized (pullManager) {
            if (this.needRefresh) {
                updateTrackers = true;
                this.needRefresh = false;
            }
            sites = this.sites.toArray(new Site[this.sites.size()]);
        }
        if (updateTrackers) {
            this.updateTrackers(sites);
        }
        Site[] siteArray = sites;
        int n = sites.length;
        int n2 = 0;
        while (n2 < n) {
            Site site = siteArray[n2];
            if (this.needRefresh || !this.running) {
                return;
            }
            try {
                if (site.isDue()) {
                    site.markProcessed();
                    this.processSite(site, localContext);
                }
            }
            catch (Exception e) {
                logger.warn("Failed to process site: " + site.getId(), (Throwable)e);
            }
            ++n2;
        }
    }

    private void updateTrackers(Site[] sites) {
        logger.info("Updating trackers");
        HashMap<String, DataSourceFactoryTracker> newTrackers = new HashMap<String, DataSourceFactoryTracker>();
        Site[] siteArray = sites;
        int n = sites.length;
        int n2 = 0;
        while (n2 < n) {
            Site site = siteArray[n2];
            logger.debug("Checking driver - {}", (Object)site.getDriverName());
            if (newTrackers.containsKey(site.getDriverName())) {
                logger.debug("New tracker list already contains driver");
            } else {
                DataSourceFactoryTracker tracker = this.dataSourceFactoryTrackers.remove(site.getDriverName());
                if (tracker != null) {
                    logger.debug("Taking tracker from old list");
                    newTrackers.put(site.getDriverName(), tracker);
                } else {
                    try {
                        logger.debug("Creating new tracker");
                        tracker = new DataSourceFactoryTracker(Activator.getContext(), site.getDriverName(), null);
                        tracker.open();
                        newTrackers.put(site.getDriverName(), tracker);
                    }
                    catch (InvalidSyntaxException e) {
                        logger.warn("Failed to create tracker", (Throwable)e);
                    }
                }
            }
            ++n2;
        }
        ArrayList<DataSourceFactoryTracker> closeTrackers = new ArrayList<DataSourceFactoryTracker>(this.dataSourceFactoryTrackers.values());
        this.dataSourceFactoryTrackers = newTrackers;
        for (DataSourceFactoryTracker tracker : closeTrackers) {
            logger.debug("Closing old tracker: {}", (Object)tracker.getDriver());
            tracker.close();
        }
    }

    public synchronized void update(UserInformation userInformation, String configurationId, Map<String, String> properties) throws Exception {
        this.needRefresh = true;
        Site oldSite = this.performDelete(configurationId);
        Site site = this.createSite(configurationId, properties);
        if (oldSite != null) {
            site.setLastProcess(oldSite.getLastProcess());
        }
        if (site == null) {
            return;
        }
        this.sites.add(site);
        this.notifyAll();
    }

    private Site performDelete(String configurationId) {
        Iterator<Site> i = this.sites.iterator();
        while (i.hasNext()) {
            Site site = i.next();
            if (!site.getId().equals(configurationId)) continue;
            i.remove();
            return site;
        }
        return null;
    }

    private void processSite(final Site site, final ConnectionContext localContext) throws Exception {
        logger.info("Processing site: {}", (Object)site.getId());
        DataSourceFactoryTracker tracker = this.dataSourceFactoryTrackers.get(site.getDriverName());
        if (tracker == null) {
            throw new IllegalStateException("Site is configured but has not data source factory tracker");
        }
        DataSourceFactory factory = (DataSourceFactory)tracker.getService();
        if (factory == null) {
            throw new IllegalStateException(String.format("Site's driver could not be found - %s", site.getDriverName()));
        }
        DataSourceConnectionAccessor accessor = new DataSourceConnectionAccessor(factory, site.getProperties());
        try {
            accessor.doWithConnection((ConnectionTask)new CommonConnectionTask<Void>(){

                protected Void performTask(ConnectionContext context) throws Exception {
                    PullManager.this.transferSite(site, localContext, context);
                    return null;
                }
            });
        }
        finally {
            accessor.dispose();
        }
    }

    protected void transferSite(final Site site, final ConnectionContext localContext, final ConnectionContext context) throws SQLException {
        localContext.setAutoCommit(false);
        context.setAutoCommit(false);
        context.query(new RowCallback(){

            public void processRow(ResultSet resultSet) throws SQLException {
                PullManager.this.transferEntry(site, localContext, context, resultSet);
                if (PullManager.this.needRefresh) {
                    throw new RuntimeException("Configuration data was refreshed. We abort...");
                }
            }
        }, this.makeSelectSql(site), new Object[0]);
        logger.info("Starting commit ... local ... ");
        localContext.commit();
        logger.info("Starting commit ... global ... ");
        context.commit();
        logger.info("Comitted");
    }

    protected void transferEntry(Site site, ConnectionContext localContext, ConnectionContext context, ResultSet resultSet) throws SQLException {
        String id = resultSet.getString(1);
        if (!this.entryExists(localContext, id)) {
            logger.debug("Inserting event {} into local data store", (Object)id);
            localContext.update(String.format("INSERT INTO %sOPENSCADA_AE_REP ( ID, ENTRY_TIMESTAMP, NODE_ID, DATA ) VALUES ( ?, ?, ? , ?)", this.getSchema()), new Object[]{resultSet.getObject(1), resultSet.getObject(2), resultSet.getObject(3), resultSet.getObject(4)});
        }
        logger.debug("Deleting entry {} in local site", (Object)id);
        context.update(this.makeDeleteSql(site), new Object[]{resultSet.getObject(1)});
    }

    private boolean entryExists(ConnectionContext localContext, String id) throws SQLException {
        List result = localContext.query((RowMapper)new SingleColumnRowMapper(Number.class), String.format("SELECT COUNT(*) FROM %sOPENSCADA_AE_REP WHERE ID=?", this.getSchema()), new Object[]{id});
        if (result.isEmpty()) {
            return false;
        }
        return ((Number)result.get(0)).intValue() > 0;
    }

    private String getSchema() {
        return System.getProperty("org.eclipse.scada.ae.slave.pull.local.schema", "");
    }

    private String makeDeleteSql(Site site) {
        if (site.getCustomDeleteSql() != null) {
            return site.getCustomDeleteSql();
        }
        return String.format("DELETE FROM %sOPENSCADA_AE_REP WHERE ID=?", this.getSiteSchema(site));
    }

    private String makeSelectSql(Site site) {
        if (site.getCustomSelectSql() != null) {
            return site.getCustomSelectSql();
        }
        return String.format("SELECT ID, ENTRY_TIMESTAMP, NODE_ID, DATA from %sOPENSCADA_AE_REP", this.getSiteSchema(site));
    }

    private String getSiteSchema(Site site) {
        if (site.getSchema() == null) {
            return "";
        }
        return site.getSchema();
    }

    private Site createSite(String configurationId, Map<String, String> properties) throws Exception {
        ConfigurationDataHelper cfg = new ConfigurationDataHelper(properties);
        String driverName = cfg.getStringChecked("driverName", "'driverName' must be set");
        Properties jdbcProperties = cfg.getPrefixedProperties("jdbcProperties.");
        long delay = cfg.getLong("delay", 10000L);
        String schema = cfg.getString("schema", "");
        String customSelectSql = cfg.getString("customSelectSql", null);
        String customDeleteSql = cfg.getString("customDeleteSql", null);
        return new Site(configurationId, driverName, jdbcProperties, schema, delay, customSelectSql, customDeleteSql);
    }

    public synchronized void delete(UserInformation userInformation, String configurationId) throws Exception {
        this.performDelete(configurationId);
        this.needRefresh = true;
        this.notifyAll();
    }
}

