/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.core.server.common;

import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.Future;
import org.eclipse.scada.core.server.Service;
import org.eclipse.scada.core.server.Session;
import org.eclipse.scada.core.server.common.DefaultAuthentication;
import org.eclipse.scada.core.server.common.DefaultAuthorization;
import org.eclipse.scada.core.server.common.Messages;
import org.eclipse.scada.core.server.common.session.AbstractSessionImpl;
import org.eclipse.scada.sec.AuthenticationImplementation;
import org.eclipse.scada.sec.AuthorizationImplementation;
import org.eclipse.scada.sec.AuthorizationReply;
import org.eclipse.scada.sec.AuthorizationRequest;
import org.eclipse.scada.sec.AuthorizationResult;
import org.eclipse.scada.sec.PermissionDeniedException;
import org.eclipse.scada.sec.StatusCodes;
import org.eclipse.scada.sec.UserInformation;
import org.eclipse.scada.sec.audit.AuditLogService;
import org.eclipse.scada.sec.audit.log.slf4j.LogServiceImpl;
import org.eclipse.scada.sec.authz.AuthorizationContext;
import org.eclipse.scada.sec.callback.CallbackHandler;
import org.eclipse.scada.utils.concurrent.CallingFuture;
import org.eclipse.scada.utils.concurrent.FutureListener;
import org.eclipse.scada.utils.concurrent.InstantFuture;
import org.eclipse.scada.utils.concurrent.NotifyFuture;
import org.eclipse.scada.utils.statuscodes.StatusCode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ServiceCommon<S extends Session, SI extends AbstractSessionImpl>
implements Service<S> {
    private static final Logger logger = LoggerFactory.getLogger(ServiceCommon.class);
    protected static final AuthorizationResult DEFAULT_RESULT = AuthorizationResult.createReject((StatusCode)StatusCodes.AUTHORIZATION_FAILED, (String)Messages.getString("ServiceCommon.DefaultMessage"));
    private AuthorizationImplementation authorizationImplementation;
    private AuthenticationImplementation authenticationImplementation = new DefaultAuthentication();
    private AuditLogService auditLogService;

    public ServiceCommon() {
        this.authorizationImplementation = new DefaultAuthorization(new AuthenticationImplementation(){

            public UserInformation getUser(String user) {
                return ServiceCommon.this.authenticationImplementation.getUser(user);
            }

            public NotifyFuture<UserInformation> authenticate(CallbackHandler callbackHandler) {
                return ServiceCommon.this.authenticationImplementation.authenticate(callbackHandler);
            }
        });
        this.auditLogService = new LogServiceImpl();
    }

    public void setAuditLogService(AuditLogService auditLogService) {
        this.auditLogService = auditLogService == null ? new LogServiceImpl() : auditLogService;
    }

    protected void setAuthenticationImplementation(AuthenticationImplementation authenticationImplementation) {
        this.authenticationImplementation = authenticationImplementation;
    }

    protected void setAuthorizationImplementation(AuthorizationImplementation authorizationImplementation) {
        this.authorizationImplementation = authorizationImplementation;
    }

    protected Set<String> extractPrivileges(Properties properties) {
        HashSet<String> result = new HashSet<String>();
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            String key;
            if (!(entry.getKey() instanceof String) || !(entry.getValue() instanceof String) || !(key = (String)entry.getKey()).startsWith("session.privilege.")) continue;
            String priv = key.substring("session.privilege.".length());
            result.add(priv);
        }
        return result;
    }

    protected NotifyFuture<UserInformation> loginUser(Properties properties, Map<String, Object> contextInformation, CallbackHandler callbackHandler) {
        NotifyFuture<AuthorizationReply> future = this.authorize(new AuthorizationRequest("SESSION", null, "CONNECT", UserInformation.ANONYMOUS, contextInformation), callbackHandler);
        return new CallingFuture<AuthorizationReply, UserInformation>(future){

            public UserInformation call(Future<AuthorizationReply> future) throws Exception {
                AuthorizationReply authResult = future.get();
                PermissionDeniedException e = authResult.getResult().asException();
                if (e != null) {
                    logger.debug("Failed to login user", (Throwable)e);
                    throw e;
                }
                return authResult.getUserInformation();
            }
        };
    }

    protected void fillSessionProperties(UserInformation userInformation, Map<String, String> sessionResultProperties) {
        if (userInformation != null && !userInformation.isAnonymous()) {
            sessionResultProperties.put("userInformation.name", userInformation.getName());
        }
        if (userInformation != null && userInformation.getRoles() != null) {
            for (String role : userInformation.getRoles()) {
                sessionResultProperties.put(String.format("userInformation.roles.%s", role), "true");
            }
        }
    }

    protected NotifyFuture<AuthorizationReply> authorize(AuthorizationRequest request, CallbackHandler callbackHandler) {
        return this.authorize(request, callbackHandler, DEFAULT_RESULT);
    }

    protected NotifyFuture<AuthorizationReply> authorize(final AuthorizationRequest request, CallbackHandler callbackHandler, AuthorizationResult defaultResult) {
        final AuthorizationContext context = new AuthorizationContext();
        context.setCallbackHandler(callbackHandler);
        context.setRequest(request);
        this.auditLogService.authorizationRequested(request);
        NotifyFuture result = this.authorizationImplementation.authorize(context, defaultResult);
        result.addListener((FutureListener)new FutureListener<AuthorizationReply>(){

            public void complete(Future<AuthorizationReply> future) {
                try {
                    ServiceCommon.this.auditLogService.authorizationDone(context, request, future.get());
                }
                catch (Exception e) {
                    ServiceCommon.this.auditLogService.authorizationFailed(context, request, (Throwable)e);
                }
            }
        });
        return result;
    }

    protected NotifyFuture<UserInformation> makeEffectiveUserInformation(AbstractSessionImpl session, final String targetUser, CallbackHandler handler) {
        UserInformation sessionUser = session.getUserInformation();
        if (sessionUser == null) {
            logger.debug("Session has no user information. Using anonymous.");
            sessionUser = UserInformation.ANONYMOUS;
        }
        if (targetUser == null) {
            logger.debug("target user is null");
            return new InstantFuture((Object)sessionUser);
        }
        if (targetUser.equals(sessionUser.getName())) {
            logger.debug("Session user and target user match ... using session user");
            return new InstantFuture((Object)sessionUser);
        }
        logger.debug("Trying to set target user: {}", (Object)targetUser);
        NotifyFuture<AuthorizationReply> future = this.authorize(new AuthorizationRequest("SESSION", targetUser, "PROXY_USER", session.getUserInformation(), null), handler);
        return new CallingFuture<AuthorizationReply, UserInformation>(future){

            public UserInformation call(Future<AuthorizationReply> future) throws Exception {
                AuthorizationReply result = future.get();
                if (!result.isGranted()) {
                    logger.info("Proxy user is not allowed");
                    throw result.getResult().asException();
                }
                UserInformation resultUser = ServiceCommon.this.authenticationImplementation.getUser(targetUser);
                logger.debug("Allowed to proxy user - {} -> {}", (Object)targetUser, (Object)resultUser);
                if (resultUser == null) {
                    logger.debug("User is not known, so fall back to anonymous");
                    return UserInformation.ANONYMOUS;
                }
                return resultUser;
            }
        };
    }
}

