/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.core.client.ngp;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import org.apache.mina.core.service.IoProcessor;
import org.apache.mina.transport.socket.nio.NioSession;
import org.eclipse.scada.core.ConnectionInformation;
import org.eclipse.scada.core.client.ConnectionState;
import org.eclipse.scada.core.client.common.ClientBaseConnection;
import org.eclipse.scada.core.client.common.IoHandlerFactory;
import org.eclipse.scada.core.client.ngp.CallbackHandlerManager;
import org.eclipse.scada.core.client.ngp.OpenCallbacksManager;
import org.eclipse.scada.core.client.ngp.ProtocolIoHandlerFactory;
import org.eclipse.scada.core.data.CallbackRequest;
import org.eclipse.scada.core.data.CallbackResponse;
import org.eclipse.scada.core.data.ErrorInformation;
import org.eclipse.scada.core.data.Request;
import org.eclipse.scada.core.data.RequestMessage;
import org.eclipse.scada.core.data.Response;
import org.eclipse.scada.core.data.ResponseMessage;
import org.eclipse.scada.core.data.message.CreateSession;
import org.eclipse.scada.core.data.message.RequestCallbacks;
import org.eclipse.scada.core.data.message.RespondCallbacks;
import org.eclipse.scada.core.data.message.SessionAccepted;
import org.eclipse.scada.core.data.message.SessionPrivilegesChanged;
import org.eclipse.scada.core.data.message.SessionRejected;
import org.eclipse.scada.core.ngp.MessageSender;
import org.eclipse.scada.core.ngp.ResponseManager;
import org.eclipse.scada.protocol.common.IoLoggerFilterChainBuilder;
import org.eclipse.scada.protocol.ngp.common.FilterChainBuilder;
import org.eclipse.scada.protocol.ngp.common.ProtocolConfigurationFactory;
import org.eclipse.scada.sec.callback.Callback;
import org.eclipse.scada.sec.callback.CallbackFactory;
import org.eclipse.scada.sec.callback.CallbackHandler;
import org.eclipse.scada.sec.callback.DefaultCallbackFactory;
import org.eclipse.scada.utils.ExceptionHelper;
import org.eclipse.scada.utils.concurrent.FutureListener;
import org.eclipse.scada.utils.concurrent.NotifyFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectionBaseImpl
extends ClientBaseConnection {
    private static final Logger logger = LoggerFactory.getLogger(ConnectionBaseImpl.class);
    private final ResponseManager responseManager;
    private final MessageSender messageSender = new MessageSender(){

        public void sendMessage(Object message) {
            ConnectionBaseImpl.this.sendMessage(message);
        }
    };
    private final CallbackHandlerManager callbackHandlerManager;
    private CallbackFactory callbackFactory;
    private final OpenCallbacksManager callbackManager;

    public ConnectionBaseImpl(ProtocolConfigurationFactory protocolConfigurationFactory, ConnectionInformation connectionInformation, IoProcessor<NioSession> processor) throws Exception {
        super((IoHandlerFactory)new ProtocolIoHandlerFactory(protocolConfigurationFactory), (IoLoggerFilterChainBuilder)new FilterChainBuilder(true), connectionInformation, processor);
        this.responseManager = new ResponseManager(this.statistics, this.messageSender, (Executor)this.executor);
        this.callbackHandlerManager = new CallbackHandlerManager(this.statistics);
        this.callbackManager = new OpenCallbacksManager((Object)this, this.statistics, this.executor);
        this.callbackFactory = new DefaultCallbackFactory();
    }

    public void setCallbackFactory(CallbackFactory callbackFactory) {
        this.callbackFactory = callbackFactory;
    }

    protected void onConnectionConnected() {
        this.responseManager.connected();
        Map<String, String> properties = this.makeProperties();
        logger.info("Requesting new session: {}", properties);
        Long callbackHandlerId = this.registerCallbackHandler(this.nextRequest(), this.connectCallbackHandler);
        this.sendMessage(new CreateSession(properties, callbackHandlerId));
    }

    protected Map<String, String> makeProperties() {
        HashMap<String, String> result = new HashMap<String, String>(this.connectionInformation.getProperties());
        result.put("feature.core.session.privileges", "true");
        result.put("feature.core.callbacks", "true");
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onConnectionClosed() {
        super.onConnectionClosed();
        ConnectionBaseImpl connectionBaseImpl = this;
        synchronized (connectionBaseImpl) {
            this.responseManager.disconnected();
            this.callbackManager.disconnected();
        }
    }

    protected synchronized void handleMessage(Object message) {
        logger.trace("handleMessage: {}", message);
        if (message instanceof SessionAccepted) {
            this.handleSessionAccepted((SessionAccepted)message);
        } else if (message instanceof SessionRejected) {
            this.performDisconnected(new IllegalStateException(String.format("Failed to create session. Reply: %s", ((SessionRejected)message).getErrorReason())).fillInStackTrace());
        } else if (message instanceof SessionPrivilegesChanged) {
            this.handlePrivilegeChange((SessionPrivilegesChanged)message);
        } else if (message instanceof RequestCallbacks) {
            this.handleRequestCallbacks((RequestCallbacks)message);
        } else if (message instanceof ResponseMessage) {
            this.handleResponse((ResponseMessage)message);
        }
    }

    private void handleResponse(ResponseMessage message) {
        this.callbackHandlerManager.unregisterHandler(message.getResponse().getRequest().getRequestId());
        this.responseManager.handleResponse(message);
    }

    private void handleRequestCallbacks(final RequestCallbacks message) {
        CallbackHandler callbackHandler = this.callbackHandlerManager.getHandler(message.getCallbackHandlerId());
        if (callbackHandler == null || this.callbackFactory == null) {
            this.sendMessage(new RespondCallbacks(new Response(message.getRequest()), this.allCallbacksCanceled(message.getCallbacks().size()), null));
            return;
        }
        final Callback[] callbacks = new Callback[message.getCallbacks().size()];
        int i = 0;
        for (CallbackRequest cr : message.getCallbacks()) {
            callbacks[i] = this.callbackFactory.createCallback(cr.getType(), cr.getAttributes());
            logger.debug("Created callback #{}: {}", (Object)i, (Object)callbacks[i]);
            ++i;
        }
        NotifyFuture<Callback[]> future = this.callbackManager.processCallbacks(callbackHandler, callbacks, message.getTimeoutMillis());
        future.addListener((FutureListener)new FutureListener<Callback[]>(){

            public void complete(Future<Callback[]> future) {
                ConnectionBaseImpl.this.processCallbackFuture(message.getRequest(), future, callbacks);
            }
        });
    }

    protected void processCallbackFuture(Request request, Future<Callback[]> future, Callback[] callbacks) {
        logger.debug("Processing callback result - request: {}, future: {}", (Object)request, future);
        LinkedList<CallbackResponse> result = new LinkedList<CallbackResponse>();
        ErrorInformation errorInformation = null;
        try {
            future.get();
            Callback[] callbackArray = callbacks;
            int n = callbacks.length;
            int n2 = 0;
            while (n2 < n) {
                Callback cb = callbackArray[n2];
                boolean canceled = cb.isCanceled();
                Map attributes = !canceled ? cb.buildResponseAttributes() : Collections.emptyMap();
                logger.debug("Callback result - canceled: {}, attributes: {}", (Object)canceled, (Object)attributes);
                result.add(new CallbackResponse(canceled, attributes));
                ++n2;
            }
        }
        catch (Exception e) {
            logger.warn("Failed to build result map", (Throwable)e);
            errorInformation = new ErrorInformation(null, ExceptionHelper.getMessage((Throwable)e), ExceptionHelper.formatted((Throwable)e));
            result.clear();
        }
        this.sendMessage(new RespondCallbacks(new Response(request), result, errorInformation));
    }

    private List<CallbackResponse> allCallbacksCanceled(int count) {
        ArrayList<CallbackResponse> response = new ArrayList<CallbackResponse>(count);
        int i = 0;
        while (i < count) {
            response.add(new CallbackResponse(true, Collections.emptyMap()));
            ++i;
        }
        return response;
    }

    private void handleSessionAccepted(SessionAccepted message) {
        Map properties = message.getProperties();
        this.setSessionProperties(properties);
        this.switchState(ConnectionState.BOUND, null);
    }

    protected synchronized Long registerCallbackHandler(Request request, CallbackHandler callbackHandler) {
        if (callbackHandler == null) {
            return null;
        }
        this.callbackHandlerManager.registerHandler(request.getRequestId(), callbackHandler);
        return request.getRequestId();
    }

    private void handlePrivilegeChange(SessionPrivilegesChanged message) {
        this.firePrivilegeChange(message.getGranted());
    }

    protected Request nextRequest() {
        return this.responseManager.nextRequest();
    }

    protected synchronized NotifyFuture<ResponseMessage> sendRequestMessage(RequestMessage requestMessage) {
        return this.responseManager.sendRequestMessage(requestMessage);
    }
}

