/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.da.server.exporter.modbus.internal;

import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import org.apache.mina.core.service.IoProcessor;
import org.apache.mina.transport.socket.nio.NioSession;
import org.eclipse.scada.ca.ConfigurationDataHelper;
import org.eclipse.scada.da.server.common.DataItem;
import org.eclipse.scada.da.server.exporter.common.HiveSource;
import org.eclipse.scada.da.server.exporter.modbus.ModbusExport;
import org.eclipse.scada.da.server.exporter.modbus.io.AbstractSourceType;
import org.eclipse.scada.da.server.exporter.modbus.io.DoubleType;
import org.eclipse.scada.da.server.exporter.modbus.io.IntegerType;
import org.eclipse.scada.da.server.exporter.modbus.io.ShortIntegerType;
import org.eclipse.scada.da.server.exporter.modbus.io.SourceDefinition;
import org.eclipse.scada.da.server.exporter.modbus.io.UnsignedIntegerType;
import org.eclipse.scada.da.server.exporter.modbus.io.UnsignedShortIntegerType;
import org.eclipse.scada.utils.osgi.pool.ManageableObjectPool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModbusExportImpl
extends ModbusExport {
    private static final Logger logger = LoggerFactory.getLogger(ModbusExportImpl.class);

    public ModbusExportImpl(String id, ScheduledExecutorService executor, IoProcessor<NioSession> processor, HiveSource hiveSource, ManageableObjectPool<DataItem> itemObjectPool) {
        super(id, executor, processor, hiveSource, itemObjectPool);
    }

    public void update(Map<String, String> parameters) throws Exception {
        ConfigurationDataHelper cfg = new ConfigurationDataHelper(parameters);
        this.setReadTimeout(cfg.getInteger("timeout", 10000));
        this.setPort(cfg.getInteger("port", 502));
        this.setSlaveId((short)cfg.getInteger("slaveId", 1));
        this.setProperties(cfg.getPrefixedProperties("hive."));
        this.configureDefinitions(cfg);
    }

    protected void configureDefinitions(ConfigurationDataHelper cfg) {
        LinkedList<SourceDefinition> defs = new LinkedList<SourceDefinition>();
        for (Map.Entry entry : cfg.getPrefixed("item.").entrySet()) {
            String itemId = (String)entry.getKey();
            String[] args = ((String)entry.getValue()).split(":");
            logger.info("Adding - itemId: {}, arguments: {}", (Object)itemId, (Object)args);
            defs.add(this.convert(itemId, args));
        }
        this.setBlockConfiguration(defs);
    }

    private SourceDefinition convert(String itemId, String[] args) {
        AbstractSourceType type;
        int offset = Integer.parseInt(args[0]);
        switch (args[1].toUpperCase()) {
            case "DOUBLE": {
                type = new DoubleType(ModbusExportImpl.getFactor(args));
                break;
            }
            case "INT16": 
            case "SHORT": {
                type = new ShortIntegerType(ModbusExportImpl.getFactor(args));
                break;
            }
            case "UINT16": 
            case "WORD": {
                type = new UnsignedShortIntegerType(ModbusExportImpl.getFactor(args));
                break;
            }
            case "INT32": {
                type = new IntegerType(ModbusExportImpl.getFactor(args));
                break;
            }
            case "UINT32": {
                type = new UnsignedIntegerType(ModbusExportImpl.getFactor(args));
                break;
            }
            default: {
                throw new IllegalArgumentException(String.format("Type '%s' is unknown.", args[1]));
            }
        }
        return new SourceDefinition(itemId, offset * 2, type);
    }

    private static Double getFactor(String[] args) {
        if (args.length > 2) {
            return Double.parseDouble(args[2]);
        }
        return null;
    }
}

