/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.da.server.exporter.modbus.io;

import org.apache.mina.core.buffer.IoBuffer;
import org.eclipse.scada.core.Variant;
import org.eclipse.scada.da.server.exporter.modbus.io.AbstractSourceType;
import org.eclipse.scada.da.server.exporter.modbus.io.SourceType;

public class UnsignedIntegerType
extends AbstractSourceType {
    private final Double factor;
    private static final int DATA_LENGTH = 4;
    public static final int LENGTH = 14;
    public static final SourceType INSTANCE = new UnsignedIntegerType();

    public UnsignedIntegerType(Double factor) {
        super(4);
        this.factor = factor;
    }

    public UnsignedIntegerType() {
        this(null);
    }

    @Override
    public void putValue(IoBuffer slice, Variant value) {
        slice.putUnsignedInt(this.makeValue(value));
    }

    @Override
    public Variant getValue(int localOffset, IoBuffer value) {
        if (localOffset == 10 && value.remaining() == 4) {
            return Variant.valueOf((long)value.getUnsignedInt());
        }
        return null;
    }

    private long makeValue(Variant value) {
        if (value == null) {
            return 0L;
        }
        if (this.factor == null) {
            Long v = value.asLong(null);
            if (v == null) {
                return 0L;
            }
            return v;
        }
        Double v = value.asDouble(null);
        if (v == null) {
            return 0L;
        }
        return (long)(this.factor * v);
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.factor == null ? 0 : this.factor.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UnsignedIntegerType)) {
            return false;
        }
        UnsignedIntegerType other = (UnsignedIntegerType)obj;
        return !(this.factor == null ? other.factor != null : !this.factor.equals(other.factor));
    }
}

