/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.core.server.net;

import java.net.SocketAddress;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.mina.core.session.IdleStatus;
import org.apache.mina.core.session.IoSession;
import org.apache.mina.handler.multiton.SingleSessionIoHandler;
import org.eclipse.scada.core.ConnectionInformation;
import org.eclipse.scada.core.net.ConnectionHelper;
import org.eclipse.scada.core.net.MessageHelper;
import org.eclipse.scada.core.server.common.stats.ManagedConnection;
import org.eclipse.scada.net.base.PingService;
import org.eclipse.scada.net.base.data.Message;
import org.eclipse.scada.net.mina.IoSessionSender;
import org.eclipse.scada.net.mina.MessageSender;
import org.eclipse.scada.net.mina.Messenger;
import org.eclipse.scada.utils.stats.StatisticEntry;
import org.eclipse.scada.utils.stats.StatisticsImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractServerConnectionHandler
implements SingleSessionIoHandler {
    private static final Logger logger = LoggerFactory.getLogger(AbstractServerConnectionHandler.class);
    private static final Object STATS_PINGS_SENT = new Object();
    private static final Object STATS_SESSION_BYTES_READ = new Object();
    private static final Object STATS_SESSION_BYTES_WRITTEN = new Object();
    private static final Object STATS_SESSION_STARTED = new Object();
    private static final int DEFAULT_TIMEOUT = 10000;
    protected IoSession ioSession;
    protected final Messenger messenger;
    protected final PingService pingService;
    protected final ConnectionInformation connectionInformation;
    private final StatisticsImpl statistics;
    private ManagedConnection mxBean;
    private boolean sessionStarted;
    private Set<String> privileges;

    public AbstractServerConnectionHandler(IoSession ioSession, ConnectionInformation connectionInformation) {
        this.ioSession = ioSession;
        this.connectionInformation = connectionInformation;
        this.statistics = new StatisticsImpl();
        this.messenger = new Messenger((long)this.getMessageTimeout(), this.statistics);
        this.pingService = new PingService(this.messenger);
        this.ioSession.getConfig().setReaderIdleTime(this.getPingPeriod() / 1000);
        this.messenger.connected((MessageSender)new IoSessionSender(this.ioSession, this.statistics));
        this.mxBean = ManagedConnection.register((ManagedConnection)new ManagedConnection(){

            protected Collection<StatisticEntry> getEntries() {
                return AbstractServerConnectionHandler.this.statistics.getEntries();
            }

            public Map<String, String> getTransportProperties() {
                return null;
            }

            public void close() {
                AbstractServerConnectionHandler.this.ioSession.close(false);
            }
        }, (SocketAddress)ioSession.getRemoteAddress(), (String)"org.eclipse.scada.core.server.net");
        this.statistics.setLabel(STATS_PINGS_SENT, "Pings sent");
        this.statistics.setLabel(STATS_SESSION_BYTES_READ, "Bytes read in session");
        this.statistics.setLabel(STATS_SESSION_BYTES_WRITTEN, "Bytes written in session");
        this.statistics.setLabel(STATS_SESSION_STARTED, "Session started");
    }

    protected void sessionConfigured(Map<String, String> properties) {
        logger.info("Configure session");
        this.modifyFilterChain(this.ioSession, properties);
    }

    protected Map<String, Object> createDefaultContext() {
        HashMap<String, Object> result = new HashMap<String, Object>(1);
        result.put("remoteAddress", this.ioSession.getRemoteAddress());
        return result;
    }

    protected void sendPrivilegeChange(Set<String> privileges) {
        this.privileges = privileges;
        if (this.sessionStarted && privileges != null) {
            this.messenger.sendMessage(MessageHelper.createPrivilegeChange(privileges));
        }
    }

    protected void modifyFilterChain(IoSession ioSession, Map<String, String> properties) {
        ConnectionHelper.injectCompression((IoSession)ioSession, (String)properties.get("transport.request.compression"));
    }

    protected Map<String, String> getTransportProperties(Properties props) {
        HashMap<String, String> transportProperties = new HashMap<String, String>();
        if (props.containsKey("transport.request.compression")) {
            if (this.isCompressionDenied()) {
                logger.info("Remote peer requested compression but we don't allow compression");
            } else {
                transportProperties.put("transport.request.compression", props.getProperty("transport.request.compression"));
            }
        }
        return transportProperties;
    }

    private boolean isCompressionDenied() {
        if (this.getBooleanProperty("transport.reject.compression", false)) {
            return true;
        }
        return Boolean.getBoolean("org.eclipse.scada.core.server.net.rejectCompression");
    }

    protected void replySessionCreated(Properties originalProperties, Message originalMessage, Map<String, String> sessionProperties) {
        logger.debug("Reply session created: {}", (Object)originalMessage);
        Map<String, String> transportProperties = this.getTransportProperties(originalProperties);
        logger.debug("Transport properties: {}", transportProperties);
        this.messenger.sendMessage(MessageHelper.createSessionACK((Message)originalMessage, sessionProperties, transportProperties));
        this.sessionConfigured(transportProperties);
        if (!originalProperties.containsKey(MessageHelper.PROP_USING_SESSION_START)) {
            logger.debug("Starting session directly");
            this.startSession();
        }
    }

    public void exceptionCaught(Throwable cause) throws Exception {
        logger.warn("Something failed", cause);
    }

    public void messageReceived(Object message) throws Exception {
        if (message instanceof Message) {
            this.statistics.setCurrentValue(STATS_SESSION_BYTES_READ, (double)this.ioSession.getReadBytes());
            if (((Message)message).getCommandCode() == 65540) {
                this.startSession();
            } else {
                this.messenger.messageReceived((Message)message);
            }
        }
    }

    protected void startSession() {
        logger.info("Received request to start session");
        if (this.sessionStarted) {
            logger.warn("Received session start multiple times");
            return;
        }
        this.sessionStarted = true;
        this.statistics.setCurrentValue(STATS_SESSION_STARTED, 1.0);
        if (this.privileges != null && !this.privileges.isEmpty()) {
            this.sendPrivilegeChange(this.privileges);
        }
        this.pingService.start();
    }

    public void messageSent(Object message) throws Exception {
        this.statistics.setCurrentValue(STATS_SESSION_BYTES_WRITTEN, (double)this.ioSession.getWrittenBytes());
        this.statistics.setCurrentValue(IoSessionSender.STATS_QUEUED_BYTES, (double)this.ioSession.getScheduledWriteBytes());
    }

    public void sessionClosed() throws Exception {
        this.cleanUp();
    }

    protected void cleanUp() {
        if (this.mxBean != null) {
            this.mxBean.dispose();
            this.mxBean = null;
        }
        if (this.ioSession != null) {
            this.messenger.disconnected();
            this.ioSession.close(true);
            this.ioSession = null;
        }
    }

    public void sessionCreated() throws Exception {
    }

    public void sessionIdle(IdleStatus status) throws Exception {
        this.pingService.sendPing();
        this.statistics.changeCurrentValue(STATS_PINGS_SENT, 1.0);
    }

    public void sessionOpened() throws Exception {
    }

    public int getPingPeriod() {
        return this.getIntProperty("pingPeriod", this.getIntProperty("timeout", 10000) / this.getIntProperty("pingFrequency", 3));
    }

    public int getMessageTimeout() {
        return this.getIntProperty("messageTimeout", this.getIntProperty("timeout", 10000));
    }

    protected boolean getBooleanProperty(String propertyName, boolean defaultValue) {
        try {
            String timeout = (String)this.connectionInformation.getProperties().get(propertyName);
            return Boolean.parseBoolean(timeout);
        }
        catch (Exception exception) {
            return defaultValue;
        }
    }

    protected int getIntProperty(String propertyName, int defaultValue) {
        try {
            String timeout = (String)this.connectionInformation.getProperties().get(propertyName);
            int i = Integer.parseInt(timeout);
            if (i <= 0) {
                return defaultValue;
            }
            return i;
        }
        catch (Exception exception) {
            return defaultValue;
        }
    }
}

