/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.da.server.common.memory;

import java.util.Map;
import org.apache.mina.core.buffer.IoBuffer;
import org.eclipse.scada.core.Variant;
import org.eclipse.scada.da.server.common.memory.AbstractAttribute;
import org.eclipse.scada.da.server.common.memory.MemoryRequestBlock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TriBitAttribute
extends AbstractAttribute {
    private static final Logger logger = LoggerFactory.getLogger(TriBitAttribute.class);
    private final int readIndex;
    private final int readSubIndex;
    private final int writeTrueIndex;
    private final int writeTrueSubIndex;
    private final int writeFalseIndex;
    private final int writeFalseSubIndex;
    private final boolean invertRead;
    private Boolean lastValue;
    private Variant lastTimestamp;
    private final boolean enableTimestamp;
    private long stopped;

    public TriBitAttribute(String name, int readIndex, int readSubIndex, int writeTrueIndex, int writeTrueSubIndex, int writeFalseIndex, int writeFalseSubIndex, boolean invertRead, boolean enableTimestamp) {
        super(name);
        this.readIndex = readIndex;
        this.readSubIndex = readSubIndex;
        this.writeTrueIndex = writeTrueIndex;
        this.writeTrueSubIndex = writeTrueSubIndex;
        this.writeFalseIndex = writeFalseIndex;
        this.writeFalseSubIndex = writeFalseSubIndex;
        this.invertRead = invertRead;
        this.enableTimestamp = enableTimestamp;
    }

    @Override
    public void handleData(IoBuffer data, Map<String, Variant> attributes, Variant timestamp) {
        boolean flag;
        byte b = data.get(this.toAddress(this.readIndex));
        boolean bl = flag = (b & 1 << this.readSubIndex) != 0;
        if (this.invertRead) {
            attributes.put(this.name, flag ? Variant.FALSE : Variant.TRUE);
        } else {
            attributes.put(this.name, flag ? Variant.TRUE : Variant.FALSE);
        }
        if (!Boolean.valueOf(flag).equals(this.lastValue)) {
            this.lastValue = flag;
            this.lastTimestamp = timestamp;
        }
        if (this.enableTimestamp) {
            attributes.put(String.valueOf(this.name) + ".timestamp", this.lastTimestamp);
        }
    }

    @Override
    public void stop() {
        this.stopped = System.currentTimeMillis();
        super.stop();
    }

    @Override
    public void handleError(Map<String, Variant> attributes) {
        this.lastValue = null;
        this.lastTimestamp = null;
    }

    @Override
    public void handleWrite(Variant value) {
        MemoryRequestBlock block = this.block;
        if (block == null) {
            logger.warn("Was stopped: {}", (Object)this.stopped);
            throw new IllegalStateException("Device is not connected");
        }
        boolean flag = value.asBoolean();
        if (flag) {
            block.writeBit(this.toAddress(this.writeTrueIndex), this.writeTrueSubIndex, true);
        } else {
            block.writeBit(this.toAddress(this.writeFalseIndex), this.writeFalseSubIndex, true);
        }
    }
}

