/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.da.datasource;

import java.util.Collection;
import java.util.Dictionary;
import java.util.LinkedList;
import java.util.Set;
import org.eclipse.scada.da.datasource.DataSource;
import org.eclipse.scada.utils.osgi.pool.ObjectPoolListener;
import org.eclipse.scada.utils.osgi.pool.ObjectPoolServiceTracker;
import org.eclipse.scada.utils.osgi.pool.ObjectPoolTracker;
import org.osgi.framework.InvalidSyntaxException;

public class MultiDataSourceTracker {
    private final Collection<ObjectPoolServiceTracker<DataSource>> trackers = new LinkedList<ObjectPoolServiceTracker<DataSource>>();
    private final ServiceListener listener;

    public MultiDataSourceTracker(ObjectPoolTracker<DataSource> poolTracker, Set<String> dataSourceIds, ServiceListener listener) throws InvalidSyntaxException {
        this.listener = listener;
        for (final String id : dataSourceIds) {
            ObjectPoolServiceTracker tracker = new ObjectPoolServiceTracker(poolTracker, id, (ObjectPoolListener)new ObjectPoolListener<DataSource>(){

                public void serviceRemoved(DataSource service, Dictionary<?, ?> properties) {
                    MultiDataSourceTracker.this.handleRemoved(id, properties, service);
                }

                public void serviceModified(DataSource service, Dictionary<?, ?> properties) {
                    MultiDataSourceTracker.this.handleModified(id, properties, service);
                }

                public void serviceAdded(DataSource service, Dictionary<?, ?> properties) {
                    MultiDataSourceTracker.this.handleAdded(id, properties, service);
                }
            });
            this.trackers.add((ObjectPoolServiceTracker<DataSource>)tracker);
        }
    }

    protected void handleAdded(String id, Dictionary<?, ?> properties, DataSource service) {
        this.listener.dataSourceAdded(id, properties, service);
    }

    protected void handleModified(String id, Dictionary<?, ?> properties, DataSource service) {
        this.listener.dataSourceModified(id, properties, service);
    }

    protected void handleRemoved(String id, Dictionary<?, ?> properties, DataSource service) {
        this.listener.dataSourceRemoved(id, properties, service);
    }

    public synchronized void open() {
        for (ObjectPoolServiceTracker<DataSource> tracker : this.trackers) {
            tracker.open();
        }
    }

    public synchronized void close() {
        for (ObjectPoolServiceTracker<DataSource> tracker : this.trackers) {
            tracker.close();
        }
    }

    public static interface ServiceListener {
        public void dataSourceAdded(String var1, Dictionary<?, ?> var2, DataSource var3);

        public void dataSourceRemoved(String var1, Dictionary<?, ?> var2, DataSource var3);

        public void dataSourceModified(String var1, Dictionary<?, ?> var2, DataSource var3);
    }
}

