/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.net.base;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.scada.net.base.InvalidMessageReplyException;
import org.eclipse.scada.net.base.LongRunningOperation;
import org.eclipse.scada.net.base.MessageListener;
import org.eclipse.scada.net.base.MessageStateListener;
import org.eclipse.scada.net.base.MessageTimeoutException;
import org.eclipse.scada.net.base.data.LongValue;
import org.eclipse.scada.net.base.data.Message;
import org.eclipse.scada.net.base.data.Value;
import org.eclipse.scada.net.mina.Messenger;
import org.eclipse.scada.utils.exec.LongRunningListener;
import org.eclipse.scada.utils.exec.LongRunningState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LongRunningController
implements MessageListener {
    private static final Logger logger = LoggerFactory.getLogger(LongRunningController.class);
    private final Set<Integer> commandCodes = new HashSet<Integer>();
    private Messenger connectionHandler = null;
    private final Map<Long, LongRunningOperation> opMap = new HashMap<Long, LongRunningOperation>();

    public LongRunningController(Messenger connectionHandler, int commandCode) {
        this.connectionHandler = connectionHandler;
        this.commandCodes.add(commandCode);
    }

    public LongRunningController(Messenger connectionHandler, Set<Integer> commandCodes) {
        this.connectionHandler = connectionHandler;
        this.commandCodes.addAll(commandCodes);
    }

    public LongRunningController(Messenger connectionHandler, Integer ... commandCodes) {
        this.connectionHandler = connectionHandler;
        this.commandCodes.addAll(Arrays.asList(commandCodes));
    }

    public void register() {
        for (Integer commandCode : this.commandCodes) {
            this.connectionHandler.setHandler(commandCode, this);
        }
    }

    public void unregister() {
        for (Integer commandCode : this.commandCodes) {
            this.connectionHandler.unsetHandler(commandCode);
        }
    }

    public synchronized LongRunningOperation start(Message message, LongRunningListener listener) {
        if (message == null) {
            return null;
        }
        final LongRunningOperation op = new LongRunningOperation(this, listener);
        this.connectionHandler.sendMessage(message, new MessageStateListener(){

            @Override
            public void messageReply(Message message) {
                Value value = message.getValues().get("id");
                if (value instanceof LongValue) {
                    long id = ((LongValue)value).getValue();
                    op.granted(id);
                    LongRunningController.this.assignOperation(id, op);
                    return;
                }
                Value errorValue = message.getValues().get("error-info");
                if (errorValue != null) {
                    String errorInfo = errorValue.toString();
                    op.fail(new InvalidMessageReplyException(errorInfo).fillInStackTrace());
                    return;
                }
                op.fail(new InvalidMessageReplyException("Message did not contain 'id' field").fillInStackTrace());
            }

            @Override
            public void messageTimedOut() {
                op.fail(new MessageTimeoutException().fillInStackTrace());
            }
        });
        if (listener != null) {
            listener.stateChanged((org.eclipse.scada.utils.exec.LongRunningOperation)op, LongRunningState.REQUESTED, null);
        }
        return op;
    }

    private synchronized void assignOperation(long id, LongRunningOperation op) {
        this.opMap.put(id, op);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void messageReceived(Message message) {
        Value value = message.getValues().get("id");
        if (!(value instanceof LongValue)) {
            return;
        }
        long id = ((LongValue)value).getValue();
        logger.debug("Received long-op reply with id {}", (Object)id);
        if (id != 0L) {
            LongRunningOperation op;
            Map<Long, LongRunningOperation> map = this.opMap;
            synchronized (map) {
                op = this.opMap.get(id);
                this.opMap.remove(id);
            }
            if (op != null) {
                op.result(message);
            } else {
                logger.warn("Received long-op message for unregistered operation");
            }
        }
    }
}

