/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.core.connection.provider;

import java.util.Map;
import org.eclipse.scada.core.connection.provider.ConnectionService;
import org.eclipse.scada.utils.osgi.FilterUtil;
import org.eclipse.scada.utils.osgi.SingleServiceListener;
import org.eclipse.scada.utils.osgi.SingleServiceTracker;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ConnectionTracker {
    private static final Logger logger = LoggerFactory.getLogger(ConnectionTracker.class);
    private SingleServiceTracker<ConnectionService> tracker;
    private Filter filter;
    private final Listener listener;
    private ConnectionService service;
    private final BundleContext context;
    private final Class<? extends ConnectionService> clazz;

    public ConnectionTracker(BundleContext context, Listener listener, Class<? extends ConnectionService> clazz) {
        this.context = context;
        this.listener = listener;
        this.clazz = clazz;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SingleServiceTracker<ConnectionService> createTracker() {
        ConnectionTracker connectionTracker = this;
        synchronized (connectionTracker) {
            if (this.filter == null) {
                this.filter = this.createFilter();
            }
            logger.debug("Creating tracker for: {}", (Object)this.filter);
            if (this.filter != null) {
                return new SingleServiceTracker(this.context, this.filter, (SingleServiceListener)new SingleServiceListener<ConnectionService>(){

                    public void serviceChange(ServiceReference<ConnectionService> reference, ConnectionService service) {
                        ConnectionTracker.this.setService(reference, service);
                    }
                });
            }
            return null;
        }
    }

    protected Filter createFilter() {
        try {
            Class<ConnectionService> filterClazz = this.clazz != null ? this.clazz : ConnectionService.class;
            return FilterUtil.createAndFilter((String)filterClazz.getName(), this.createFilterParameters());
        }
        catch (InvalidSyntaxException e) {
            logger.warn("Failed to create filter", (Throwable)e);
            return null;
        }
    }

    protected abstract Map<String, String> createFilterParameters();

    public synchronized void listen() {
        if (this.tracker == null) {
            this.tracker = this.createTracker();
        }
        if (this.tracker != null) {
            logger.debug("Opening tracker");
            this.tracker.open();
        }
    }

    public synchronized void open() {
        this.listen();
    }

    public synchronized void close() {
        this.unlisten();
    }

    public synchronized void unlisten() {
        if (this.tracker != null) {
            this.tracker.close();
        }
    }

    protected synchronized void setService(ServiceReference<ConnectionService> reference, ConnectionService service) {
        logger.debug("Set service: {} -> {}", new Object[]{reference, service});
        this.service = service;
        if (this.listener != null) {
            this.listener.setConnection(service);
        }
    }

    public synchronized ConnectionService getService() {
        return this.service;
    }

    public ConnectionService waitForService(long timeout) throws InterruptedException {
        if (this.tracker == null) {
            return null;
        }
        return (ConnectionService)this.tracker.waitForService(timeout);
    }

    public static interface Listener {
        public void setConnection(ConnectionService var1);
    }
}

