/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.da.server.browser.common.query;

import java.util.regex.Pattern;
import org.eclipse.scada.da.server.browser.common.query.GroupProvider;
import org.eclipse.scada.da.server.browser.common.query.ItemDescriptor;
import org.eclipse.scada.da.server.browser.common.query.NameProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SplitGroupProvider
implements GroupProvider {
    private static final Logger logger = LoggerFactory.getLogger(SplitGroupProvider.class);
    private final NameProvider nameProvider;
    private final Pattern regex;
    private final int skipPrefix;
    private final int skipSuffix;

    public SplitGroupProvider(NameProvider nameProvider, String regex) {
        this(nameProvider, Pattern.compile(regex), 0, 0);
    }

    public SplitGroupProvider(NameProvider nameProvider, Pattern pattern, int skipPrefix, int skipSuffix) {
        this.nameProvider = nameProvider;
        this.regex = pattern;
        this.skipPrefix = skipPrefix;
        this.skipSuffix = skipSuffix;
    }

    public SplitGroupProvider(NameProvider nameProvider, String regex, int skipPrefix, int skipSuffix) {
        this(nameProvider, Pattern.compile(regex), skipPrefix, skipSuffix);
    }

    @Override
    public String[] getGrouping(ItemDescriptor descriptor) {
        if (this.nameProvider == null) {
            return null;
        }
        String name = this.nameProvider.getName(descriptor);
        if (name == null) {
            return null;
        }
        try {
            String[] tok = this.regex.split(name);
            if (this.skipPrefix + this.skipSuffix >= tok.length) {
                return new String[0];
            }
            String[] result = new String[tok.length - (this.skipPrefix + this.skipSuffix)];
            int i = this.skipPrefix;
            while (i < tok.length - this.skipSuffix) {
                result[i - this.skipPrefix] = tok[i];
                ++i;
            }
            return result;
        }
        catch (Exception e) {
            logger.warn("Failed to split", (Throwable)e);
            return null;
        }
    }
}

